// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DevCenter.Models
{
    /// <summary> Indicates whether the environment type is either enabled or disabled. </summary>
    public readonly partial struct EnvironmentTypeEnableStatus : IEquatable<EnvironmentTypeEnableStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EnvironmentTypeEnableStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EnvironmentTypeEnableStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IsEnabledValue = "Enabled";
        private const string IsDisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static EnvironmentTypeEnableStatus IsEnabled { get; } = new EnvironmentTypeEnableStatus(IsEnabledValue);
        /// <summary> Disabled. </summary>
        public static EnvironmentTypeEnableStatus IsDisabled { get; } = new EnvironmentTypeEnableStatus(IsDisabledValue);
        /// <summary> Determines if two <see cref="EnvironmentTypeEnableStatus"/> values are the same. </summary>
        public static bool operator ==(EnvironmentTypeEnableStatus left, EnvironmentTypeEnableStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EnvironmentTypeEnableStatus"/> values are not the same. </summary>
        public static bool operator !=(EnvironmentTypeEnableStatus left, EnvironmentTypeEnableStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EnvironmentTypeEnableStatus"/>. </summary>
        public static implicit operator EnvironmentTypeEnableStatus(string value) => new EnvironmentTypeEnableStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EnvironmentTypeEnableStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EnvironmentTypeEnableStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
