// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DevCenter.Models
{
    /// <summary> The frequency of task execution. </summary>
    public readonly partial struct DevCenterScheduledFrequency : IEquatable<DevCenterScheduledFrequency>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DevCenterScheduledFrequency"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DevCenterScheduledFrequency(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DailyValue = "Daily";

        /// <summary> Daily. </summary>
        public static DevCenterScheduledFrequency Daily { get; } = new DevCenterScheduledFrequency(DailyValue);
        /// <summary> Determines if two <see cref="DevCenterScheduledFrequency"/> values are the same. </summary>
        public static bool operator ==(DevCenterScheduledFrequency left, DevCenterScheduledFrequency right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DevCenterScheduledFrequency"/> values are not the same. </summary>
        public static bool operator !=(DevCenterScheduledFrequency left, DevCenterScheduledFrequency right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DevCenterScheduledFrequency"/>. </summary>
        public static implicit operator DevCenterScheduledFrequency(string value) => new DevCenterScheduledFrequency(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DevCenterScheduledFrequency other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DevCenterScheduledFrequency other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
