// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DevCenter.Models
{
    /// <summary> Provisioning state of the resource. </summary>
    public readonly partial struct DevCenterProvisioningState : IEquatable<DevCenterProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DevCenterProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DevCenterProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string AcceptedValue = "Accepted";
        private const string RunningValue = "Running";
        private const string CreatingValue = "Creating";
        private const string CreatedValue = "Created";
        private const string UpdatingValue = "Updating";
        private const string UpdatedValue = "Updated";
        private const string DeletingValue = "Deleting";
        private const string DeletedValue = "Deleted";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string MovingResourcesValue = "MovingResources";
        private const string TransientFailureValue = "TransientFailure";
        private const string RolloutInProgressValue = "RolloutInProgress";
        private const string StorageProvisioningFailedValue = "StorageProvisioningFailed";

        /// <summary> NotSpecified. </summary>
        public static DevCenterProvisioningState NotSpecified { get; } = new DevCenterProvisioningState(NotSpecifiedValue);
        /// <summary> Accepted. </summary>
        public static DevCenterProvisioningState Accepted { get; } = new DevCenterProvisioningState(AcceptedValue);
        /// <summary> Running. </summary>
        public static DevCenterProvisioningState Running { get; } = new DevCenterProvisioningState(RunningValue);
        /// <summary> Creating. </summary>
        public static DevCenterProvisioningState Creating { get; } = new DevCenterProvisioningState(CreatingValue);
        /// <summary> Created. </summary>
        public static DevCenterProvisioningState Created { get; } = new DevCenterProvisioningState(CreatedValue);
        /// <summary> Updating. </summary>
        public static DevCenterProvisioningState Updating { get; } = new DevCenterProvisioningState(UpdatingValue);
        /// <summary> Updated. </summary>
        public static DevCenterProvisioningState Updated { get; } = new DevCenterProvisioningState(UpdatedValue);
        /// <summary> Deleting. </summary>
        public static DevCenterProvisioningState Deleting { get; } = new DevCenterProvisioningState(DeletingValue);
        /// <summary> Deleted. </summary>
        public static DevCenterProvisioningState Deleted { get; } = new DevCenterProvisioningState(DeletedValue);
        /// <summary> Succeeded. </summary>
        public static DevCenterProvisioningState Succeeded { get; } = new DevCenterProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static DevCenterProvisioningState Failed { get; } = new DevCenterProvisioningState(FailedValue);
        /// <summary> Canceled. </summary>
        public static DevCenterProvisioningState Canceled { get; } = new DevCenterProvisioningState(CanceledValue);
        /// <summary> MovingResources. </summary>
        public static DevCenterProvisioningState MovingResources { get; } = new DevCenterProvisioningState(MovingResourcesValue);
        /// <summary> TransientFailure. </summary>
        public static DevCenterProvisioningState TransientFailure { get; } = new DevCenterProvisioningState(TransientFailureValue);
        /// <summary> RolloutInProgress. </summary>
        public static DevCenterProvisioningState RolloutInProgress { get; } = new DevCenterProvisioningState(RolloutInProgressValue);
        /// <summary> StorageProvisioningFailed. </summary>
        public static DevCenterProvisioningState StorageProvisioningFailed { get; } = new DevCenterProvisioningState(StorageProvisioningFailedValue);
        /// <summary> Determines if two <see cref="DevCenterProvisioningState"/> values are the same. </summary>
        public static bool operator ==(DevCenterProvisioningState left, DevCenterProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DevCenterProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(DevCenterProvisioningState left, DevCenterProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DevCenterProvisioningState"/>. </summary>
        public static implicit operator DevCenterProvisioningState(string value) => new DevCenterProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DevCenterProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DevCenterProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
