// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.DevCenter.Models
{
    /// <summary> The devcenter resource for partial updates. Properties not provided in the update request will not be changed. </summary>
    public partial class DevCenterPatch : DevCenterTrackedResourceUpdate
    {
        /// <summary> Initializes a new instance of <see cref="DevCenterPatch"/>. </summary>
        public DevCenterPatch()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DevCenterPatch"/>. </summary>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="location"> The geo-location where the resource lives. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="identity"> Managed identity properties. </param>
        internal DevCenterPatch(IDictionary<string, string> tags, AzureLocation? location, IDictionary<string, BinaryData> serializedAdditionalRawData, ManagedServiceIdentity identity) : base(tags, location, serializedAdditionalRawData)
        {
            Identity = identity;
        }

        /// <summary> Managed identity properties. </summary>
        public ManagedServiceIdentity Identity { get; set; }
    }
}
