// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DevCenter.Models
{
    /// <summary> Indicates whether hibernate is enabled/disabled. </summary>
    public readonly partial struct DevCenterHibernateSupport : IEquatable<DevCenterHibernateSupport>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DevCenterHibernateSupport"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DevCenterHibernateSupport(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IsDisabledValue = "Disabled";
        private const string IsEnabledValue = "Enabled";

        /// <summary> Disabled. </summary>
        public static DevCenterHibernateSupport IsDisabled { get; } = new DevCenterHibernateSupport(IsDisabledValue);
        /// <summary> Enabled. </summary>
        public static DevCenterHibernateSupport IsEnabled { get; } = new DevCenterHibernateSupport(IsEnabledValue);
        /// <summary> Determines if two <see cref="DevCenterHibernateSupport"/> values are the same. </summary>
        public static bool operator ==(DevCenterHibernateSupport left, DevCenterHibernateSupport right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DevCenterHibernateSupport"/> values are not the same. </summary>
        public static bool operator !=(DevCenterHibernateSupport left, DevCenterHibernateSupport right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DevCenterHibernateSupport"/>. </summary>
        public static implicit operator DevCenterHibernateSupport(string value) => new DevCenterHibernateSupport(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DevCenterHibernateSupport other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DevCenterHibernateSupport other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
