// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DevCenter.Models
{
    /// <summary> Health status indicating whether a pool is available to create Dev Boxes. </summary>
    public readonly partial struct DevCenterHealthStatus : IEquatable<DevCenterHealthStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DevCenterHealthStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DevCenterHealthStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string PendingValue = "Pending";
        private const string HealthyValue = "Healthy";
        private const string WarningValue = "Warning";
        private const string UnhealthyValue = "Unhealthy";

        /// <summary> Unknown. </summary>
        public static DevCenterHealthStatus Unknown { get; } = new DevCenterHealthStatus(UnknownValue);
        /// <summary> Pending. </summary>
        public static DevCenterHealthStatus Pending { get; } = new DevCenterHealthStatus(PendingValue);
        /// <summary> Healthy. </summary>
        public static DevCenterHealthStatus Healthy { get; } = new DevCenterHealthStatus(HealthyValue);
        /// <summary> Warning. </summary>
        public static DevCenterHealthStatus Warning { get; } = new DevCenterHealthStatus(WarningValue);
        /// <summary> Unhealthy. </summary>
        public static DevCenterHealthStatus Unhealthy { get; } = new DevCenterHealthStatus(UnhealthyValue);
        /// <summary> Determines if two <see cref="DevCenterHealthStatus"/> values are the same. </summary>
        public static bool operator ==(DevCenterHealthStatus left, DevCenterHealthStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DevCenterHealthStatus"/> values are not the same. </summary>
        public static bool operator !=(DevCenterHealthStatus left, DevCenterHealthStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DevCenterHealthStatus"/>. </summary>
        public static implicit operator DevCenterHealthStatus(string value) => new DevCenterHealthStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DevCenterHealthStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DevCenterHealthStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
