// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DevCenter.Models
{
    /// <summary> Health check status values. </summary>
    public readonly partial struct DevCenterHealthCheckStatus : IEquatable<DevCenterHealthCheckStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DevCenterHealthCheckStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DevCenterHealthCheckStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string PendingValue = "Pending";
        private const string RunningValue = "Running";
        private const string PassedValue = "Passed";
        private const string WarningValue = "Warning";
        private const string FailedValue = "Failed";

        /// <summary> Unknown. </summary>
        public static DevCenterHealthCheckStatus Unknown { get; } = new DevCenterHealthCheckStatus(UnknownValue);
        /// <summary> Pending. </summary>
        public static DevCenterHealthCheckStatus Pending { get; } = new DevCenterHealthCheckStatus(PendingValue);
        /// <summary> Running. </summary>
        public static DevCenterHealthCheckStatus Running { get; } = new DevCenterHealthCheckStatus(RunningValue);
        /// <summary> Passed. </summary>
        public static DevCenterHealthCheckStatus Passed { get; } = new DevCenterHealthCheckStatus(PassedValue);
        /// <summary> Warning. </summary>
        public static DevCenterHealthCheckStatus Warning { get; } = new DevCenterHealthCheckStatus(WarningValue);
        /// <summary> Failed. </summary>
        public static DevCenterHealthCheckStatus Failed { get; } = new DevCenterHealthCheckStatus(FailedValue);
        /// <summary> Determines if two <see cref="DevCenterHealthCheckStatus"/> values are the same. </summary>
        public static bool operator ==(DevCenterHealthCheckStatus left, DevCenterHealthCheckStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DevCenterHealthCheckStatus"/> values are not the same. </summary>
        public static bool operator !=(DevCenterHealthCheckStatus left, DevCenterHealthCheckStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DevCenterHealthCheckStatus"/>. </summary>
        public static implicit operator DevCenterHealthCheckStatus(string value) => new DevCenterHealthCheckStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DevCenterHealthCheckStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DevCenterHealthCheckStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
