// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DevCenter.Models
{
    /// <summary> An individual health check item. </summary>
    public partial class DevCenterHealthCheck
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DevCenterHealthCheck"/>. </summary>
        internal DevCenterHealthCheck()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DevCenterHealthCheck"/>. </summary>
        /// <param name="status"> The status of the health check item. </param>
        /// <param name="displayName"> The display name of this health check item. </param>
        /// <param name="startOn"> Start time of health check item. </param>
        /// <param name="endOn"> End time of the health check item. </param>
        /// <param name="errorType"> The type of error that occurred during this health check. </param>
        /// <param name="recommendedAction"> The recommended action to fix the corresponding error. </param>
        /// <param name="additionalDetails"> Additional details about the health check or the recommended action. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DevCenterHealthCheck(DevCenterHealthCheckStatus? status, string displayName, DateTimeOffset? startOn, DateTimeOffset? endOn, string errorType, string recommendedAction, string additionalDetails, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Status = status;
            DisplayName = displayName;
            StartOn = startOn;
            EndOn = endOn;
            ErrorType = errorType;
            RecommendedAction = recommendedAction;
            AdditionalDetails = additionalDetails;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The status of the health check item. </summary>
        public DevCenterHealthCheckStatus? Status { get; }
        /// <summary> The display name of this health check item. </summary>
        public string DisplayName { get; }
        /// <summary> Start time of health check item. </summary>
        public DateTimeOffset? StartOn { get; }
        /// <summary> End time of the health check item. </summary>
        public DateTimeOffset? EndOn { get; }
        /// <summary> The type of error that occurred during this health check. </summary>
        public string ErrorType { get; }
        /// <summary> The recommended action to fix the corresponding error. </summary>
        public string RecommendedAction { get; }
        /// <summary> Additional details about the health check or the recommended action. </summary>
        public string AdditionalDetails { get; }
    }
}
