// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.DevCenter.Models
{
    /// <summary> Partial update of a Dev Box definition resource. </summary>
    public partial class DevBoxDefinitionPatch : DevCenterTrackedResourceUpdate
    {
        /// <summary> Initializes a new instance of <see cref="DevBoxDefinitionPatch"/>. </summary>
        public DevBoxDefinitionPatch()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DevBoxDefinitionPatch"/>. </summary>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="location"> The geo-location where the resource lives. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="imageReference"> Image reference information. </param>
        /// <param name="sku"> The SKU for Dev Boxes created using this definition. </param>
        /// <param name="osStorageType"> The storage type used for the Operating System disk of Dev Boxes created using this definition. </param>
        /// <param name="hibernateSupport"> Indicates whether Dev Boxes created with this definition are capable of hibernation. Not all images are capable of supporting hibernation. To find out more see https://aka.ms/devbox/hibernate. </param>
        internal DevBoxDefinitionPatch(IDictionary<string, string> tags, AzureLocation? location, IDictionary<string, BinaryData> serializedAdditionalRawData, DevCenterImageReference imageReference, DevCenterSku sku, string osStorageType, DevCenterHibernateSupport? hibernateSupport) : base(tags, location, serializedAdditionalRawData)
        {
            ImageReference = imageReference;
            Sku = sku;
            OSStorageType = osStorageType;
            HibernateSupport = hibernateSupport;
        }

        /// <summary> Image reference information. </summary>
        public DevCenterImageReference ImageReference { get; set; }
        /// <summary> The SKU for Dev Boxes created using this definition. </summary>
        public DevCenterSku Sku { get; set; }
        /// <summary> The storage type used for the Operating System disk of Dev Boxes created using this definition. </summary>
        public string OSStorageType { get; set; }
        /// <summary> Indicates whether Dev Boxes created with this definition are capable of hibernation. Not all images are capable of supporting hibernation. To find out more see https://aka.ms/devbox/hibernate. </summary>
        public DevCenterHibernateSupport? HibernateSupport { get; set; }
    }
}
