// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.DevCenter
{
    internal class DevCenterScheduleOperationSource : IOperationSource<DevCenterScheduleResource>
    {
        private readonly ArmClient _client;

        internal DevCenterScheduleOperationSource(ArmClient client)
        {
            _client = client;
        }

        DevCenterScheduleResource IOperationSource<DevCenterScheduleResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DevCenterScheduleData.DeserializeDevCenterScheduleData(document.RootElement);
            return new DevCenterScheduleResource(_client, data);
        }

        async ValueTask<DevCenterScheduleResource> IOperationSource<DevCenterScheduleResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DevCenterScheduleData.DeserializeDevCenterScheduleData(document.RootElement);
            return new DevCenterScheduleResource(_client, data);
        }
    }
}
