// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.DevCenter
{
    internal class DevCenterProjectOperationSource : IOperationSource<DevCenterProjectResource>
    {
        private readonly ArmClient _client;

        internal DevCenterProjectOperationSource(ArmClient client)
        {
            _client = client;
        }

        DevCenterProjectResource IOperationSource<DevCenterProjectResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DevCenterProjectData.DeserializeDevCenterProjectData(document.RootElement);
            return new DevCenterProjectResource(_client, data);
        }

        async ValueTask<DevCenterProjectResource> IOperationSource<DevCenterProjectResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DevCenterProjectData.DeserializeDevCenterProjectData(document.RootElement);
            return new DevCenterProjectResource(_client, data);
        }
    }
}
