// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.DevCenter
{
    internal class DevCenterPoolOperationSource : IOperationSource<DevCenterPoolResource>
    {
        private readonly ArmClient _client;

        internal DevCenterPoolOperationSource(ArmClient client)
        {
            _client = client;
        }

        DevCenterPoolResource IOperationSource<DevCenterPoolResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DevCenterPoolData.DeserializeDevCenterPoolData(document.RootElement);
            return new DevCenterPoolResource(_client, data);
        }

        async ValueTask<DevCenterPoolResource> IOperationSource<DevCenterPoolResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DevCenterPoolData.DeserializeDevCenterPoolData(document.RootElement);
            return new DevCenterPoolResource(_client, data);
        }
    }
}
