// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.DevCenter
{
    internal class DevCenterGalleryOperationSource : IOperationSource<DevCenterGalleryResource>
    {
        private readonly ArmClient _client;

        internal DevCenterGalleryOperationSource(ArmClient client)
        {
            _client = client;
        }

        DevCenterGalleryResource IOperationSource<DevCenterGalleryResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DevCenterGalleryData.DeserializeDevCenterGalleryData(document.RootElement);
            return new DevCenterGalleryResource(_client, data);
        }

        async ValueTask<DevCenterGalleryResource> IOperationSource<DevCenterGalleryResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DevCenterGalleryData.DeserializeDevCenterGalleryData(document.RootElement);
            return new DevCenterGalleryResource(_client, data);
        }
    }
}
