// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.DevCenter
{
    internal class DevBoxDefinitionOperationSource : IOperationSource<DevBoxDefinitionResource>
    {
        private readonly ArmClient _client;

        internal DevBoxDefinitionOperationSource(ArmClient client)
        {
            _client = client;
        }

        DevBoxDefinitionResource IOperationSource<DevBoxDefinitionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DevBoxDefinitionData.DeserializeDevBoxDefinitionData(document.RootElement);
            return new DevBoxDefinitionResource(_client, data);
        }

        async ValueTask<DevBoxDefinitionResource> IOperationSource<DevBoxDefinitionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DevBoxDefinitionData.DeserializeDevBoxDefinitionData(document.RootElement);
            return new DevBoxDefinitionResource(_client, data);
        }
    }
}
