// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.DevCenter
{
    internal class AttachedNetworkConnectionOperationSource : IOperationSource<AttachedNetworkConnectionResource>
    {
        private readonly ArmClient _client;

        internal AttachedNetworkConnectionOperationSource(ArmClient client)
        {
            _client = client;
        }

        AttachedNetworkConnectionResource IOperationSource<AttachedNetworkConnectionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = AttachedNetworkConnectionData.DeserializeAttachedNetworkConnectionData(document.RootElement);
            return new AttachedNetworkConnectionResource(_client, data);
        }

        async ValueTask<AttachedNetworkConnectionResource> IOperationSource<AttachedNetworkConnectionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = AttachedNetworkConnectionData.DeserializeAttachedNetworkConnectionData(document.RootElement);
            return new AttachedNetworkConnectionResource(_client, data);
        }
    }
}
