// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.DevCenter.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.DevCenter
{
    /// <summary>
    /// A class representing the HealthCheckStatusDetail data model.
    /// Health Check details.
    /// </summary>
    public partial class HealthCheckStatusDetailData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HealthCheckStatusDetailData"/>. </summary>
        public HealthCheckStatusDetailData()
        {
            HealthChecks = new ChangeTrackingList<DevCenterHealthCheck>();
        }

        /// <summary> Initializes a new instance of <see cref="HealthCheckStatusDetailData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="startOn"> Start time of last execution of the health checks. </param>
        /// <param name="endOn"> End time of last execution of the health checks. </param>
        /// <param name="healthChecks"> Details for each health check item. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HealthCheckStatusDetailData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, DateTimeOffset? startOn, DateTimeOffset? endOn, IReadOnlyList<DevCenterHealthCheck> healthChecks, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            StartOn = startOn;
            EndOn = endOn;
            HealthChecks = healthChecks;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Start time of last execution of the health checks. </summary>
        public DateTimeOffset? StartOn { get; }
        /// <summary> End time of last execution of the health checks. </summary>
        public DateTimeOffset? EndOn { get; }
        /// <summary> Details for each health check item. </summary>
        public IReadOnlyList<DevCenterHealthCheck> HealthChecks { get; }
    }
}
