// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.DevCenter.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableDevCenterArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableDevCenterArmClient"/> class for mocking. </summary>
        protected MockableDevCenterArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableDevCenterArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableDevCenterArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableDevCenterArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="DevCenterResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DevCenterResource.CreateResourceIdentifier" /> to create a <see cref="DevCenterResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DevCenterResource"/> object. </returns>
        public virtual DevCenterResource GetDevCenterResource(ResourceIdentifier id)
        {
            DevCenterResource.ValidateResourceId(id);
            return new DevCenterResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DevCenterProjectResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DevCenterProjectResource.CreateResourceIdentifier" /> to create a <see cref="DevCenterProjectResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DevCenterProjectResource"/> object. </returns>
        public virtual DevCenterProjectResource GetDevCenterProjectResource(ResourceIdentifier id)
        {
            DevCenterProjectResource.ValidateResourceId(id);
            return new DevCenterProjectResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ProjectAttachedNetworkConnectionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ProjectAttachedNetworkConnectionResource.CreateResourceIdentifier" /> to create a <see cref="ProjectAttachedNetworkConnectionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ProjectAttachedNetworkConnectionResource"/> object. </returns>
        public virtual ProjectAttachedNetworkConnectionResource GetProjectAttachedNetworkConnectionResource(ResourceIdentifier id)
        {
            ProjectAttachedNetworkConnectionResource.ValidateResourceId(id);
            return new ProjectAttachedNetworkConnectionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="AttachedNetworkConnectionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="AttachedNetworkConnectionResource.CreateResourceIdentifier" /> to create an <see cref="AttachedNetworkConnectionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="AttachedNetworkConnectionResource"/> object. </returns>
        public virtual AttachedNetworkConnectionResource GetAttachedNetworkConnectionResource(ResourceIdentifier id)
        {
            AttachedNetworkConnectionResource.ValidateResourceId(id);
            return new AttachedNetworkConnectionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DevCenterGalleryResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DevCenterGalleryResource.CreateResourceIdentifier" /> to create a <see cref="DevCenterGalleryResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DevCenterGalleryResource"/> object. </returns>
        public virtual DevCenterGalleryResource GetDevCenterGalleryResource(ResourceIdentifier id)
        {
            DevCenterGalleryResource.ValidateResourceId(id);
            return new DevCenterGalleryResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DevCenterImageResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DevCenterImageResource.CreateResourceIdentifier" /> to create a <see cref="DevCenterImageResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DevCenterImageResource"/> object. </returns>
        public virtual DevCenterImageResource GetDevCenterImageResource(ResourceIdentifier id)
        {
            DevCenterImageResource.ValidateResourceId(id);
            return new DevCenterImageResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ImageVersionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ImageVersionResource.CreateResourceIdentifier" /> to create an <see cref="ImageVersionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ImageVersionResource"/> object. </returns>
        public virtual ImageVersionResource GetImageVersionResource(ResourceIdentifier id)
        {
            ImageVersionResource.ValidateResourceId(id);
            return new ImageVersionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DevCenterCatalogResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DevCenterCatalogResource.CreateResourceIdentifier" /> to create a <see cref="DevCenterCatalogResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DevCenterCatalogResource"/> object. </returns>
        public virtual DevCenterCatalogResource GetDevCenterCatalogResource(ResourceIdentifier id)
        {
            DevCenterCatalogResource.ValidateResourceId(id);
            return new DevCenterCatalogResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DevCenterEnvironmentTypeResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DevCenterEnvironmentTypeResource.CreateResourceIdentifier" /> to create a <see cref="DevCenterEnvironmentTypeResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DevCenterEnvironmentTypeResource"/> object. </returns>
        public virtual DevCenterEnvironmentTypeResource GetDevCenterEnvironmentTypeResource(ResourceIdentifier id)
        {
            DevCenterEnvironmentTypeResource.ValidateResourceId(id);
            return new DevCenterEnvironmentTypeResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="AllowedEnvironmentTypeResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="AllowedEnvironmentTypeResource.CreateResourceIdentifier" /> to create an <see cref="AllowedEnvironmentTypeResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="AllowedEnvironmentTypeResource"/> object. </returns>
        public virtual AllowedEnvironmentTypeResource GetAllowedEnvironmentTypeResource(ResourceIdentifier id)
        {
            AllowedEnvironmentTypeResource.ValidateResourceId(id);
            return new AllowedEnvironmentTypeResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DevCenterProjectEnvironmentResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DevCenterProjectEnvironmentResource.CreateResourceIdentifier" /> to create a <see cref="DevCenterProjectEnvironmentResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DevCenterProjectEnvironmentResource"/> object. </returns>
        public virtual DevCenterProjectEnvironmentResource GetDevCenterProjectEnvironmentResource(ResourceIdentifier id)
        {
            DevCenterProjectEnvironmentResource.ValidateResourceId(id);
            return new DevCenterProjectEnvironmentResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DevBoxDefinitionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DevBoxDefinitionResource.CreateResourceIdentifier" /> to create a <see cref="DevBoxDefinitionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DevBoxDefinitionResource"/> object. </returns>
        public virtual DevBoxDefinitionResource GetDevBoxDefinitionResource(ResourceIdentifier id)
        {
            DevBoxDefinitionResource.ValidateResourceId(id);
            return new DevBoxDefinitionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ProjectDevBoxDefinitionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ProjectDevBoxDefinitionResource.CreateResourceIdentifier" /> to create a <see cref="ProjectDevBoxDefinitionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ProjectDevBoxDefinitionResource"/> object. </returns>
        public virtual ProjectDevBoxDefinitionResource GetProjectDevBoxDefinitionResource(ResourceIdentifier id)
        {
            ProjectDevBoxDefinitionResource.ValidateResourceId(id);
            return new ProjectDevBoxDefinitionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DevCenterPoolResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DevCenterPoolResource.CreateResourceIdentifier" /> to create a <see cref="DevCenterPoolResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DevCenterPoolResource"/> object. </returns>
        public virtual DevCenterPoolResource GetDevCenterPoolResource(ResourceIdentifier id)
        {
            DevCenterPoolResource.ValidateResourceId(id);
            return new DevCenterPoolResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DevCenterScheduleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DevCenterScheduleResource.CreateResourceIdentifier" /> to create a <see cref="DevCenterScheduleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DevCenterScheduleResource"/> object. </returns>
        public virtual DevCenterScheduleResource GetDevCenterScheduleResource(ResourceIdentifier id)
        {
            DevCenterScheduleResource.ValidateResourceId(id);
            return new DevCenterScheduleResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DevCenterNetworkConnectionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DevCenterNetworkConnectionResource.CreateResourceIdentifier" /> to create a <see cref="DevCenterNetworkConnectionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DevCenterNetworkConnectionResource"/> object. </returns>
        public virtual DevCenterNetworkConnectionResource GetDevCenterNetworkConnectionResource(ResourceIdentifier id)
        {
            DevCenterNetworkConnectionResource.ValidateResourceId(id);
            return new DevCenterNetworkConnectionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="HealthCheckStatusDetailResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="HealthCheckStatusDetailResource.CreateResourceIdentifier" /> to create a <see cref="HealthCheckStatusDetailResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="HealthCheckStatusDetailResource"/> object. </returns>
        public virtual HealthCheckStatusDetailResource GetHealthCheckStatusDetailResource(ResourceIdentifier id)
        {
            HealthCheckStatusDetailResource.ValidateResourceId(id);
            return new HealthCheckStatusDetailResource(Client, id);
        }
    }
}
