// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.DevCenter.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.DevCenter
{
    /// <summary>
    /// A class representing the DevCenterPool data model.
    /// A pool of Virtual Machines.
    /// </summary>
    public partial class DevCenterPoolData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DevCenterPoolData"/>. </summary>
        /// <param name="location"> The location. </param>
        public DevCenterPoolData(AzureLocation location) : base(location)
        {
            HealthStatusDetails = new ChangeTrackingList<DevCenterHealthStatusDetail>();
        }

        /// <summary> Initializes a new instance of <see cref="DevCenterPoolData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="devBoxDefinitionName"> Name of a Dev Box definition in parent Project of this Pool. </param>
        /// <param name="networkConnectionName"> Name of a Network Connection in parent Project of this Pool. </param>
        /// <param name="licenseType"> Specifies the license type indicating the caller has already acquired licenses for the Dev Boxes that will be created. </param>
        /// <param name="localAdministrator"> Indicates whether owners of Dev Boxes in this pool are added as local administrators on the Dev Box. </param>
        /// <param name="stopOnDisconnect"> Stop on disconnect configuration settings for Dev Boxes created in this pool. </param>
        /// <param name="healthStatus"> Overall health status of the Pool. Indicates whether or not the Pool is available to create Dev Boxes. </param>
        /// <param name="healthStatusDetails"> Details on the Pool health status to help diagnose issues. This is only populated when the pool status indicates the pool is in a non-healthy state. </param>
        /// <param name="provisioningState"> The provisioning state of the resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DevCenterPoolData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, string devBoxDefinitionName, string networkConnectionName, DevCenterLicenseType? licenseType, LocalAdminStatus? localAdministrator, StopOnDisconnectConfiguration stopOnDisconnect, DevCenterHealthStatus? healthStatus, IReadOnlyList<DevCenterHealthStatusDetail> healthStatusDetails, DevCenterProvisioningState? provisioningState, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            DevBoxDefinitionName = devBoxDefinitionName;
            NetworkConnectionName = networkConnectionName;
            LicenseType = licenseType;
            LocalAdministrator = localAdministrator;
            StopOnDisconnect = stopOnDisconnect;
            HealthStatus = healthStatus;
            HealthStatusDetails = healthStatusDetails;
            ProvisioningState = provisioningState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DevCenterPoolData"/> for deserialization. </summary>
        internal DevCenterPoolData()
        {
        }

        /// <summary> Name of a Dev Box definition in parent Project of this Pool. </summary>
        public string DevBoxDefinitionName { get; set; }
        /// <summary> Name of a Network Connection in parent Project of this Pool. </summary>
        public string NetworkConnectionName { get; set; }
        /// <summary> Specifies the license type indicating the caller has already acquired licenses for the Dev Boxes that will be created. </summary>
        public DevCenterLicenseType? LicenseType { get; set; }
        /// <summary> Indicates whether owners of Dev Boxes in this pool are added as local administrators on the Dev Box. </summary>
        public LocalAdminStatus? LocalAdministrator { get; set; }
        /// <summary> Stop on disconnect configuration settings for Dev Boxes created in this pool. </summary>
        public StopOnDisconnectConfiguration StopOnDisconnect { get; set; }
        /// <summary> Overall health status of the Pool. Indicates whether or not the Pool is available to create Dev Boxes. </summary>
        public DevCenterHealthStatus? HealthStatus { get; }
        /// <summary> Details on the Pool health status to help diagnose issues. This is only populated when the pool status indicates the pool is in a non-healthy state. </summary>
        public IReadOnlyList<DevCenterHealthStatusDetail> HealthStatusDetails { get; }
        /// <summary> The provisioning state of the resource. </summary>
        public DevCenterProvisioningState? ProvisioningState { get; }
    }
}
