// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.DevCenter.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.DevCenter
{
    public partial class DevCenterPoolData : IUtf8JsonSerializable, IJsonModel<DevCenterPoolData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<DevCenterPoolData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<DevCenterPoolData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DevCenterPoolData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DevCenterPoolData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(DevBoxDefinitionName))
            {
                writer.WritePropertyName("devBoxDefinitionName"u8);
                writer.WriteStringValue(DevBoxDefinitionName);
            }
            if (Optional.IsDefined(NetworkConnectionName))
            {
                writer.WritePropertyName("networkConnectionName"u8);
                writer.WriteStringValue(NetworkConnectionName);
            }
            if (Optional.IsDefined(LicenseType))
            {
                writer.WritePropertyName("licenseType"u8);
                writer.WriteStringValue(LicenseType.Value.ToString());
            }
            if (Optional.IsDefined(LocalAdministrator))
            {
                writer.WritePropertyName("localAdministrator"u8);
                writer.WriteStringValue(LocalAdministrator.Value.ToString());
            }
            if (Optional.IsDefined(StopOnDisconnect))
            {
                writer.WritePropertyName("stopOnDisconnect"u8);
                writer.WriteObjectValue(StopOnDisconnect, options);
            }
            if (options.Format != "W" && Optional.IsDefined(HealthStatus))
            {
                writer.WritePropertyName("healthStatus"u8);
                writer.WriteStringValue(HealthStatus.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(HealthStatusDetails))
            {
                writer.WritePropertyName("healthStatusDetails"u8);
                writer.WriteStartArray();
                foreach (var item in HealthStatusDetails)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            writer.WriteEndObject();
        }

        DevCenterPoolData IJsonModel<DevCenterPoolData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DevCenterPoolData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DevCenterPoolData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeDevCenterPoolData(document.RootElement, options);
        }

        internal static DevCenterPoolData DeserializeDevCenterPoolData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IDictionary<string, string> tags = default;
            AzureLocation location = default;
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            string devBoxDefinitionName = default;
            string networkConnectionName = default;
            DevCenterLicenseType? licenseType = default;
            LocalAdminStatus? localAdministrator = default;
            StopOnDisconnectConfiguration stopOnDisconnect = default;
            DevCenterHealthStatus? healthStatus = default;
            IReadOnlyList<DevCenterHealthStatusDetail> healthStatusDetails = default;
            DevCenterProvisioningState? provisioningState = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("tags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    tags = dictionary;
                    continue;
                }
                if (property.NameEquals("location"u8))
                {
                    location = new AzureLocation(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("devBoxDefinitionName"u8))
                        {
                            devBoxDefinitionName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("networkConnectionName"u8))
                        {
                            networkConnectionName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("licenseType"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            licenseType = new DevCenterLicenseType(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("localAdministrator"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            localAdministrator = new LocalAdminStatus(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("stopOnDisconnect"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            stopOnDisconnect = StopOnDisconnectConfiguration.DeserializeStopOnDisconnectConfiguration(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("healthStatus"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            healthStatus = new DevCenterHealthStatus(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("healthStatusDetails"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<DevCenterHealthStatusDetail> array = new List<DevCenterHealthStatusDetail>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(DevCenterHealthStatusDetail.DeserializeDevCenterHealthStatusDetail(item, options));
                            }
                            healthStatusDetails = array;
                            continue;
                        }
                        if (property0.NameEquals("provisioningState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            provisioningState = new DevCenterProvisioningState(property0.Value.GetString());
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new DevCenterPoolData(
                id,
                name,
                type,
                systemData,
                tags ?? new ChangeTrackingDictionary<string, string>(),
                location,
                devBoxDefinitionName,
                networkConnectionName,
                licenseType,
                localAdministrator,
                stopOnDisconnect,
                healthStatus,
                healthStatusDetails ?? new ChangeTrackingList<DevCenterHealthStatusDetail>(),
                provisioningState,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<DevCenterPoolData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DevCenterPoolData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(DevCenterPoolData)} does not support writing '{options.Format}' format.");
            }
        }

        DevCenterPoolData IPersistableModel<DevCenterPoolData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DevCenterPoolData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeDevCenterPoolData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(DevCenterPoolData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<DevCenterPoolData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
