// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.DevCenter.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.DevCenter
{
    /// <summary>
    /// A class representing the DevCenterImage data model.
    /// Represents an image.
    /// </summary>
    public partial class DevCenterImageData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DevCenterImageData"/>. </summary>
        public DevCenterImageData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DevCenterImageData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="description"> The description of the image. </param>
        /// <param name="publisher"> The publisher of the image. </param>
        /// <param name="offer"> The name of the image offer. </param>
        /// <param name="sku"> The SKU name for the image. </param>
        /// <param name="recommendedMachineConfiguration"> The recommended machine configuration to use with the image. </param>
        /// <param name="provisioningState"> The provisioning state of the resource. </param>
        /// <param name="hibernateSupport"> Indicates whether this image has hibernate enabled. Not all images are capable of supporting hibernation. To find out more see https://aka.ms/devbox/hibernate. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DevCenterImageData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string description, string publisher, string offer, string sku, RecommendedMachineConfiguration recommendedMachineConfiguration, DevCenterProvisioningState? provisioningState, DevCenterHibernateSupport? hibernateSupport, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            Description = description;
            Publisher = publisher;
            Offer = offer;
            Sku = sku;
            RecommendedMachineConfiguration = recommendedMachineConfiguration;
            ProvisioningState = provisioningState;
            HibernateSupport = hibernateSupport;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The description of the image. </summary>
        public string Description { get; }
        /// <summary> The publisher of the image. </summary>
        public string Publisher { get; }
        /// <summary> The name of the image offer. </summary>
        public string Offer { get; }
        /// <summary> The SKU name for the image. </summary>
        public string Sku { get; }
        /// <summary> The recommended machine configuration to use with the image. </summary>
        public RecommendedMachineConfiguration RecommendedMachineConfiguration { get; }
        /// <summary> The provisioning state of the resource. </summary>
        public DevCenterProvisioningState? ProvisioningState { get; }
        /// <summary> Indicates whether this image has hibernate enabled. Not all images are capable of supporting hibernation. To find out more see https://aka.ms/devbox/hibernate. </summary>
        public DevCenterHibernateSupport? HibernateSupport { get; }
    }
}
