// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.DevCenter.Samples
{
    public partial class Sample_DevCenterImageCollection
    {
        // Images_ListByGallery
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ImagesListByGallery()
        {
            // Generated from example definition: specification/devcenter/resource-manager/Microsoft.DevCenter/stable/2023-04-01/examples/Images_ListByGallery.json
            // this example is just showing the usage of "Images_ListByGallery" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DevCenterGalleryResource created on azure
            // for more information of creating DevCenterGalleryResource, please refer to the document of DevCenterGalleryResource
            string subscriptionId = "0ac520ee-14c0-480f-b6c9-0a90c58ffff";
            string resourceGroupName = "rg1";
            string devCenterName = "Contoso";
            string galleryName = "DevGallery";
            ResourceIdentifier devCenterGalleryResourceId = DevCenterGalleryResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, devCenterName, galleryName);
            DevCenterGalleryResource devCenterGallery = client.GetDevCenterGalleryResource(devCenterGalleryResourceId);

            // get the collection of this DevCenterImageResource
            DevCenterImageCollection collection = devCenterGallery.GetDevCenterImages();

            // invoke the operation and iterate over the result
            await foreach (DevCenterImageResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                DevCenterImageData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Images_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ImagesGet()
        {
            // Generated from example definition: specification/devcenter/resource-manager/Microsoft.DevCenter/stable/2023-04-01/examples/Images_Get.json
            // this example is just showing the usage of "Images_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DevCenterGalleryResource created on azure
            // for more information of creating DevCenterGalleryResource, please refer to the document of DevCenterGalleryResource
            string subscriptionId = "0ac520ee-14c0-480f-b6c9-0a90c58ffff";
            string resourceGroupName = "rg1";
            string devCenterName = "Contoso";
            string galleryName = "DefaultDevGallery";
            ResourceIdentifier devCenterGalleryResourceId = DevCenterGalleryResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, devCenterName, galleryName);
            DevCenterGalleryResource devCenterGallery = client.GetDevCenterGalleryResource(devCenterGalleryResourceId);

            // get the collection of this DevCenterImageResource
            DevCenterImageCollection collection = devCenterGallery.GetDevCenterImages();

            // invoke the operation
            string imageName = "ContosoBaseImage";
            DevCenterImageResource result = await collection.GetAsync(imageName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DevCenterImageData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Images_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_ImagesGet()
        {
            // Generated from example definition: specification/devcenter/resource-manager/Microsoft.DevCenter/stable/2023-04-01/examples/Images_Get.json
            // this example is just showing the usage of "Images_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DevCenterGalleryResource created on azure
            // for more information of creating DevCenterGalleryResource, please refer to the document of DevCenterGalleryResource
            string subscriptionId = "0ac520ee-14c0-480f-b6c9-0a90c58ffff";
            string resourceGroupName = "rg1";
            string devCenterName = "Contoso";
            string galleryName = "DefaultDevGallery";
            ResourceIdentifier devCenterGalleryResourceId = DevCenterGalleryResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, devCenterName, galleryName);
            DevCenterGalleryResource devCenterGallery = client.GetDevCenterGalleryResource(devCenterGalleryResourceId);

            // get the collection of this DevCenterImageResource
            DevCenterImageCollection collection = devCenterGallery.GetDevCenterImages();

            // invoke the operation
            string imageName = "ContosoBaseImage";
            bool result = await collection.ExistsAsync(imageName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Images_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_ImagesGet()
        {
            // Generated from example definition: specification/devcenter/resource-manager/Microsoft.DevCenter/stable/2023-04-01/examples/Images_Get.json
            // this example is just showing the usage of "Images_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DevCenterGalleryResource created on azure
            // for more information of creating DevCenterGalleryResource, please refer to the document of DevCenterGalleryResource
            string subscriptionId = "0ac520ee-14c0-480f-b6c9-0a90c58ffff";
            string resourceGroupName = "rg1";
            string devCenterName = "Contoso";
            string galleryName = "DefaultDevGallery";
            ResourceIdentifier devCenterGalleryResourceId = DevCenterGalleryResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, devCenterName, galleryName);
            DevCenterGalleryResource devCenterGallery = client.GetDevCenterGalleryResource(devCenterGalleryResourceId);

            // get the collection of this DevCenterImageResource
            DevCenterImageCollection collection = devCenterGallery.GetDevCenterImages();

            // invoke the operation
            string imageName = "ContosoBaseImage";
            NullableResponse<DevCenterImageResource> response = await collection.GetIfExistsAsync(imageName);
            DevCenterImageResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                DevCenterImageData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }
    }
}
