// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.DevCenter.Samples
{
    public partial class Sample_AttachedNetworkConnectionResource
    {
        // AttachedNetworks_GetByDevCenter
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_AttachedNetworksGetByDevCenter()
        {
            // Generated from example definition: specification/devcenter/resource-manager/Microsoft.DevCenter/stable/2023-04-01/examples/AttachedNetworks_GetByDevCenter.json
            // this example is just showing the usage of "AttachedNetworks_GetByDevCenter" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AttachedNetworkConnectionResource created on azure
            // for more information of creating AttachedNetworkConnectionResource, please refer to the document of AttachedNetworkConnectionResource
            string subscriptionId = "0ac520ee-14c0-480f-b6c9-0a90c58ffff";
            string resourceGroupName = "rg1";
            string devCenterName = "Contoso";
            string attachedNetworkConnectionName = "network-uswest3";
            ResourceIdentifier attachedNetworkConnectionResourceId = AttachedNetworkConnectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, devCenterName, attachedNetworkConnectionName);
            AttachedNetworkConnectionResource attachedNetworkConnection = client.GetAttachedNetworkConnectionResource(attachedNetworkConnectionResourceId);

            // invoke the operation
            AttachedNetworkConnectionResource result = await attachedNetworkConnection.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AttachedNetworkConnectionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // AttachedNetworks_Create
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_AttachedNetworksCreate()
        {
            // Generated from example definition: specification/devcenter/resource-manager/Microsoft.DevCenter/stable/2023-04-01/examples/AttachedNetworks_Create.json
            // this example is just showing the usage of "AttachedNetworks_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AttachedNetworkConnectionResource created on azure
            // for more information of creating AttachedNetworkConnectionResource, please refer to the document of AttachedNetworkConnectionResource
            string subscriptionId = "0ac520ee-14c0-480f-b6c9-0a90c58ffff";
            string resourceGroupName = "rg1";
            string devCenterName = "Contoso";
            string attachedNetworkConnectionName = "network-uswest3";
            ResourceIdentifier attachedNetworkConnectionResourceId = AttachedNetworkConnectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, devCenterName, attachedNetworkConnectionName);
            AttachedNetworkConnectionResource attachedNetworkConnection = client.GetAttachedNetworkConnectionResource(attachedNetworkConnectionResourceId);

            // invoke the operation
            AttachedNetworkConnectionData data = new AttachedNetworkConnectionData()
            {
                NetworkConnectionId = new ResourceIdentifier("/subscriptions/0ac520ee-14c0-480f-b6c9-0a90c58ffff/resourceGroups/rg1/providers/Microsoft.DevCenter/NetworkConnections/network-uswest3"),
            };
            ArmOperation<AttachedNetworkConnectionResource> lro = await attachedNetworkConnection.UpdateAsync(WaitUntil.Completed, data);
            AttachedNetworkConnectionResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AttachedNetworkConnectionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // AttachedNetworks_Delete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_AttachedNetworksDelete()
        {
            // Generated from example definition: specification/devcenter/resource-manager/Microsoft.DevCenter/stable/2023-04-01/examples/AttachedNetworks_Delete.json
            // this example is just showing the usage of "AttachedNetworks_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AttachedNetworkConnectionResource created on azure
            // for more information of creating AttachedNetworkConnectionResource, please refer to the document of AttachedNetworkConnectionResource
            string subscriptionId = "0ac520ee-14c0-480f-b6c9-0a90c58ffff";
            string resourceGroupName = "rg1";
            string devCenterName = "Contoso";
            string attachedNetworkConnectionName = "network-uswest3";
            ResourceIdentifier attachedNetworkConnectionResourceId = AttachedNetworkConnectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, devCenterName, attachedNetworkConnectionName);
            AttachedNetworkConnectionResource attachedNetworkConnection = client.GetAttachedNetworkConnectionResource(attachedNetworkConnectionResourceId);

            // invoke the operation
            await attachedNetworkConnection.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
