// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Developer.DevCenter.Models;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.Developer.DevCenter.Samples
{
    public partial class Samples_DevCenterClient
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Project_GetProject_GetsAProject()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevCenterClient client = new DevCenterClient(endpoint, credential);

            Response response = client.GetProject("myProject", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("name").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Project_GetProject_GetsAProject_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevCenterClient client = new DevCenterClient(endpoint, credential);

            Response response = await client.GetProjectAsync("myProject", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("name").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Project_GetProject_GetsAProject_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevCenterClient client = new DevCenterClient(endpoint, credential);

            Response<DevCenterProject> response = client.GetProject("myProject");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Project_GetProject_GetsAProject_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevCenterClient client = new DevCenterClient(endpoint, credential);

            Response<DevCenterProject> response = await client.GetProjectAsync("myProject");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Project_GetProjects_ListsAllProjects()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevCenterClient client = new DevCenterClient(endpoint, credential);

            foreach (BinaryData item in client.GetProjects(null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("name").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Project_GetProjects_ListsAllProjects_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevCenterClient client = new DevCenterClient(endpoint, credential);

            await foreach (BinaryData item in client.GetProjectsAsync(null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("name").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Project_GetProjects_ListsAllProjects_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevCenterClient client = new DevCenterClient(endpoint, credential);

            foreach (DevCenterProject item in client.GetProjects())
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Project_GetProjects_ListsAllProjects_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevCenterClient client = new DevCenterClient(endpoint, credential);

            await foreach (DevCenterProject item in client.GetProjectsAsync())
            {
            }
        }
    }
}
