// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Developer.DevCenter.Models;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.Developer.DevCenter.Samples
{
    public partial class Samples_DevBoxesClient
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Pool_GetPool_GetsAPool()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            Response response = client.GetPool("myProject", "DevPool", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("location").ToString());
            Console.WriteLine(result.GetProperty("healthStatus").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Pool_GetPool_GetsAPool_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            Response response = await client.GetPoolAsync("myProject", "DevPool", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("location").ToString());
            Console.WriteLine(result.GetProperty("healthStatus").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Pool_GetPool_GetsAPool_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            Response<DevBoxPool> response = client.GetPool("myProject", "DevPool");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Pool_GetPool_GetsAPool_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            Response<DevBoxPool> response = await client.GetPoolAsync("myProject", "DevPool");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Schedule_GetSchedule_GetsASchedule()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            Response response = client.GetSchedule("myProject", "DevPool", "default", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("frequency").ToString());
            Console.WriteLine(result.GetProperty("time").ToString());
            Console.WriteLine(result.GetProperty("timeZone").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Schedule_GetSchedule_GetsASchedule_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            Response response = await client.GetScheduleAsync("myProject", "DevPool", "default", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("frequency").ToString());
            Console.WriteLine(result.GetProperty("time").ToString());
            Console.WriteLine(result.GetProperty("timeZone").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Schedule_GetSchedule_GetsASchedule_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            Response<DevBoxSchedule> response = client.GetSchedule("myProject", "DevPool", "default");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Schedule_GetSchedule_GetsASchedule_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            Response<DevBoxSchedule> response = await client.GetScheduleAsync("myProject", "DevPool", "default");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DevBox_GetDevBox_GetsADevBox()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            Response response = client.GetDevBox("myProject", "me", "MyDevBox", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("poolName").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DevBox_GetDevBox_GetsADevBox_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            Response response = await client.GetDevBoxAsync("myProject", "me", "MyDevBox", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("poolName").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DevBox_GetDevBox_GetsADevBox_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            Response<DevBox> response = client.GetDevBox("myProject", "me", "MyDevBox");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DevBox_GetDevBox_GetsADevBox_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            Response<DevBox> response = await client.GetDevBoxAsync("myProject", "me", "MyDevBox");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DevBoxesClientOperations_GetRemoteConnection_GetsRDPConnectionInfo()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            Response response = client.GetRemoteConnection("myProject", "me", "MyDevBox", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DevBoxesClientOperations_GetRemoteConnection_GetsRDPConnectionInfo_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            Response response = await client.GetRemoteConnectionAsync("myProject", "me", "MyDevBox", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DevBoxesClientOperations_GetRemoteConnection_GetsRDPConnectionInfo_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            Response<RemoteConnection> response = client.GetRemoteConnection("myProject", "me", "MyDevBox");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DevBoxesClientOperations_GetRemoteConnection_GetsRDPConnectionInfo_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            Response<RemoteConnection> response = await client.GetRemoteConnectionAsync("myProject", "me", "MyDevBox");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DevBoxAction_GetDevBoxAction_GetsAnAction()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            Response response = client.GetDevBoxAction("myProject", "me", "myDevBox", "schedule-default", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("actionType").ToString());
            Console.WriteLine(result.GetProperty("sourceId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DevBoxAction_GetDevBoxAction_GetsAnAction_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            Response response = await client.GetDevBoxActionAsync("myProject", "me", "myDevBox", "schedule-default", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("actionType").ToString());
            Console.WriteLine(result.GetProperty("sourceId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DevBoxAction_GetDevBoxAction_GetsAnAction_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            Response<DevBoxAction> response = client.GetDevBoxAction("myProject", "me", "myDevBox", "schedule-default");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DevBoxAction_GetDevBoxAction_GetsAnAction_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            Response<DevBoxAction> response = await client.GetDevBoxActionAsync("myProject", "me", "myDevBox", "schedule-default");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DevBoxesClientOperations_SkipAction_SkipsAnOccurrenceOfAnAction()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            Response response = client.SkipAction("myProject", "me", "myDevBox", "schedule-default");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DevBoxesClientOperations_SkipAction_SkipsAnOccurrenceOfAnAction_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            Response response = await client.SkipActionAsync("myProject", "me", "myDevBox", "schedule-default");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DevBoxesClientOperations_DelayAction_DelaysTheOccurrenceOfAnAction()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            Response response = client.DelayAction("myProject", "me", "myDevBox", "schedule-default", DateTimeOffset.Parse("2022-09-30T17:00:00Z"), null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("actionType").ToString());
            Console.WriteLine(result.GetProperty("sourceId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DevBoxesClientOperations_DelayAction_DelaysTheOccurrenceOfAnAction_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            Response response = await client.DelayActionAsync("myProject", "me", "myDevBox", "schedule-default", DateTimeOffset.Parse("2022-09-30T17:00:00Z"), null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("actionType").ToString());
            Console.WriteLine(result.GetProperty("sourceId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DevBoxesClientOperations_DelayAction_DelaysTheOccurrenceOfAnAction_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            Response<DevBoxAction> response = client.DelayAction("myProject", "me", "myDevBox", "schedule-default", DateTimeOffset.Parse("2022-09-30T17:00:00Z"));
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DevBoxesClientOperations_DelayAction_DelaysTheOccurrenceOfAnAction_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            Response<DevBoxAction> response = await client.DelayActionAsync("myProject", "me", "myDevBox", "schedule-default", DateTimeOffset.Parse("2022-09-30T17:00:00Z"));
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Pool_GetPools_ListsAvailablePools()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            foreach (BinaryData item in client.GetPools("myProject", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("location").ToString());
                Console.WriteLine(result.GetProperty("healthStatus").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Pool_GetPools_ListsAvailablePools_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            await foreach (BinaryData item in client.GetPoolsAsync("myProject", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("location").ToString());
                Console.WriteLine(result.GetProperty("healthStatus").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Pool_GetPools_ListsAvailablePools_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            foreach (DevBoxPool item in client.GetPools("myProject"))
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Pool_GetPools_ListsAvailablePools_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            await foreach (DevBoxPool item in client.GetPoolsAsync("myProject"))
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Schedule_GetSchedules_ListsAvailableSchedulesForAPool()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            foreach (BinaryData item in client.GetSchedules("myProject", "DevPool", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("type").ToString());
                Console.WriteLine(result.GetProperty("frequency").ToString());
                Console.WriteLine(result.GetProperty("time").ToString());
                Console.WriteLine(result.GetProperty("timeZone").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Schedule_GetSchedules_ListsAvailableSchedulesForAPool_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            await foreach (BinaryData item in client.GetSchedulesAsync("myProject", "DevPool", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("type").ToString());
                Console.WriteLine(result.GetProperty("frequency").ToString());
                Console.WriteLine(result.GetProperty("time").ToString());
                Console.WriteLine(result.GetProperty("timeZone").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Schedule_GetSchedules_ListsAvailableSchedulesForAPool_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            foreach (DevBoxSchedule item in client.GetSchedules("myProject", "DevPool"))
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Schedule_GetSchedules_ListsAvailableSchedulesForAPool_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            await foreach (DevBoxSchedule item in client.GetSchedulesAsync("myProject", "DevPool"))
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DevBoxesClientOperations_GetAllDevBoxes_ListsDevBoxesThatTheCallerHasAccessToInTheDevCenter()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            foreach (BinaryData item in client.GetAllDevBoxes(null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("poolName").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DevBoxesClientOperations_GetAllDevBoxes_ListsDevBoxesThatTheCallerHasAccessToInTheDevCenter_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            await foreach (BinaryData item in client.GetAllDevBoxesAsync(null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("poolName").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DevBoxesClientOperations_GetAllDevBoxes_ListsDevBoxesThatTheCallerHasAccessToInTheDevCenter_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            foreach (DevBox item in client.GetAllDevBoxes())
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DevBoxesClientOperations_GetAllDevBoxes_ListsDevBoxesThatTheCallerHasAccessToInTheDevCenter_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            await foreach (DevBox item in client.GetAllDevBoxesAsync())
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DevBoxesClientOperations_GetAllDevBoxesByUser_ListsDevBoxesInTheDevCenterForAParticularUser()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            foreach (BinaryData item in client.GetAllDevBoxesByUser("me", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("poolName").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DevBoxesClientOperations_GetAllDevBoxesByUser_ListsDevBoxesInTheDevCenterForAParticularUser_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            await foreach (BinaryData item in client.GetAllDevBoxesByUserAsync("me", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("poolName").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DevBoxesClientOperations_GetAllDevBoxesByUser_ListsDevBoxesInTheDevCenterForAParticularUser_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            foreach (DevBox item in client.GetAllDevBoxesByUser("me"))
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DevBoxesClientOperations_GetAllDevBoxesByUser_ListsDevBoxesInTheDevCenterForAParticularUser_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            await foreach (DevBox item in client.GetAllDevBoxesByUserAsync("me"))
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DevBoxesClientOperations_GetDevBoxes_ListsDevBoxesInTheProjectForAParticularUser()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            foreach (BinaryData item in client.GetDevBoxes("myProject", "me", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("poolName").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DevBoxesClientOperations_GetDevBoxes_ListsDevBoxesInTheProjectForAParticularUser_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            await foreach (BinaryData item in client.GetDevBoxesAsync("myProject", "me", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("poolName").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DevBoxesClientOperations_GetDevBoxes_ListsDevBoxesInTheProjectForAParticularUser_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            foreach (DevBox item in client.GetDevBoxes("myProject", "me"))
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DevBoxesClientOperations_GetDevBoxes_ListsDevBoxesInTheProjectForAParticularUser_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            await foreach (DevBox item in client.GetDevBoxesAsync("myProject", "me"))
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DevBoxAction_GetDevBoxActions_ListsActionsOnADevBox()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            foreach (BinaryData item in client.GetDevBoxActions("myProject", "me", "myDevBox", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("actionType").ToString());
                Console.WriteLine(result.GetProperty("sourceId").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DevBoxAction_GetDevBoxActions_ListsActionsOnADevBox_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            await foreach (BinaryData item in client.GetDevBoxActionsAsync("myProject", "me", "myDevBox", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("actionType").ToString());
                Console.WriteLine(result.GetProperty("sourceId").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DevBoxAction_GetDevBoxActions_ListsActionsOnADevBox_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            foreach (DevBoxAction item in client.GetDevBoxActions("myProject", "me", "myDevBox"))
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DevBoxAction_GetDevBoxActions_ListsActionsOnADevBox_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            await foreach (DevBoxAction item in client.GetDevBoxActionsAsync("myProject", "me", "myDevBox"))
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DevBoxesClientOperations_DelayAllActions_DelaysAllActions()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            foreach (BinaryData item in client.DelayAllActions("myProject", "me", "myDevBox", DateTimeOffset.Parse("2022-09-30T17:00:00Z"), null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("result").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DevBoxesClientOperations_DelayAllActions_DelaysAllActions_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            await foreach (BinaryData item in client.DelayAllActionsAsync("myProject", "me", "myDevBox", DateTimeOffset.Parse("2022-09-30T17:00:00Z"), null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("result").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DevBoxesClientOperations_DelayAllActions_DelaysAllActions_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            foreach (DevBoxActionDelayResult item in client.DelayAllActions("myProject", "me", "myDevBox", DateTimeOffset.Parse("2022-09-30T17:00:00Z")))
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DevBoxesClientOperations_DelayAllActions_DelaysAllActions_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            await foreach (DevBoxActionDelayResult item in client.DelayAllActionsAsync("myProject", "me", "myDevBox", DateTimeOffset.Parse("2022-09-30T17:00:00Z")))
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DevBoxesClientOperations_CreateDevBox_CreatesOrReplacesADevBox()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                poolName = "LargeDevWorkStationPool",
            });
            Operation<BinaryData> operation = client.CreateDevBox(WaitUntil.Completed, "myProject", "me", "MyDevBox", content);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("poolName").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DevBoxesClientOperations_CreateDevBox_CreatesOrReplacesADevBox_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                poolName = "LargeDevWorkStationPool",
            });
            Operation<BinaryData> operation = await client.CreateDevBoxAsync(WaitUntil.Completed, "myProject", "me", "MyDevBox", content);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("poolName").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DevBoxesClientOperations_DeleteDevBox_DeletesADevBox()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            Operation operation = client.DeleteDevBox(WaitUntil.Completed, "myProject", "me", "MyDevBox");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DevBoxesClientOperations_DeleteDevBox_DeletesADevBox_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            Operation operation = await client.DeleteDevBoxAsync(WaitUntil.Completed, "myProject", "me", "MyDevBox");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DevBoxesClientOperations_StartDevBox_StartsADevBox()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            Operation operation = client.StartDevBox(WaitUntil.Completed, "myProject", "me", "MyDevBox");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DevBoxesClientOperations_StartDevBox_StartsADevBox_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            Operation operation = await client.StartDevBoxAsync(WaitUntil.Completed, "myProject", "me", "MyDevBox");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DevBoxesClientOperations_StopDevBox_StopsADevBox()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            Operation operation = client.StopDevBox(WaitUntil.Completed, "myProject", "me", "MyDevBox");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DevBoxesClientOperations_StopDevBox_StopsADevBox_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            Operation operation = await client.StopDevBoxAsync(WaitUntil.Completed, "myProject", "me", "MyDevBox");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DevBoxesClientOperations_RestartDevBox_RestartsADevBox()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            Operation operation = client.RestartDevBox(WaitUntil.Completed, "myProject", "me", "MyDevBox");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DevBoxesClientOperations_RestartDevBox_RestartsADevBox_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DevBoxesClient client = new DevBoxesClient(endpoint, credential);

            Operation operation = await client.RestartDevBoxAsync(WaitUntil.Completed, "myProject", "me", "MyDevBox");
        }
    }
}
