// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Developer.DevCenter.Models;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.Developer.DevCenter.Samples
{
    public partial class Samples_DeploymentEnvironmentsClient
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Environment_GetEnvironment_GetsAnEnvironment()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeploymentEnvironmentsClient client = new DeploymentEnvironmentsClient(endpoint, credential);

            Response response = client.GetEnvironment("myProject", "me", "mydevenv", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("environmentType").ToString());
            Console.WriteLine(result.GetProperty("catalogName").ToString());
            Console.WriteLine(result.GetProperty("environmentDefinitionName").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Environment_GetEnvironment_GetsAnEnvironment_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeploymentEnvironmentsClient client = new DeploymentEnvironmentsClient(endpoint, credential);

            Response response = await client.GetEnvironmentAsync("myProject", "me", "mydevenv", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("environmentType").ToString());
            Console.WriteLine(result.GetProperty("catalogName").ToString());
            Console.WriteLine(result.GetProperty("environmentDefinitionName").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Environment_GetEnvironment_GetsAnEnvironment_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeploymentEnvironmentsClient client = new DeploymentEnvironmentsClient(endpoint, credential);

            Response<DevCenterEnvironment> response = client.GetEnvironment("myProject", "me", "mydevenv");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Environment_GetEnvironment_GetsAnEnvironment_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeploymentEnvironmentsClient client = new DeploymentEnvironmentsClient(endpoint, credential);

            Response<DevCenterEnvironment> response = await client.GetEnvironmentAsync("myProject", "me", "mydevenv");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Catalog_GetCatalog_GetsTheSpecifiedCatalogWithinTheProject()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeploymentEnvironmentsClient client = new DeploymentEnvironmentsClient(endpoint, credential);

            Response response = client.GetCatalog("myProject", "foo", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("name").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Catalog_GetCatalog_GetsTheSpecifiedCatalogWithinTheProject_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeploymentEnvironmentsClient client = new DeploymentEnvironmentsClient(endpoint, credential);

            Response response = await client.GetCatalogAsync("myProject", "foo", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("name").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Catalog_GetCatalog_GetsTheSpecifiedCatalogWithinTheProject_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeploymentEnvironmentsClient client = new DeploymentEnvironmentsClient(endpoint, credential);

            Response<DevCenterCatalog> response = client.GetCatalog("myProject", "foo");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Catalog_GetCatalog_GetsTheSpecifiedCatalogWithinTheProject_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeploymentEnvironmentsClient client = new DeploymentEnvironmentsClient(endpoint, credential);

            Response<DevCenterCatalog> response = await client.GetCatalogAsync("myProject", "foo");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_EnvironmentDefinition_GetEnvironmentDefinition_GetAnEnvironmentDefinitionFromACatalog()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeploymentEnvironmentsClient client = new DeploymentEnvironmentsClient(endpoint, credential);

            Response response = client.GetEnvironmentDefinition("myProject", "myCatalog", "foo", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("catalogName").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_EnvironmentDefinition_GetEnvironmentDefinition_GetAnEnvironmentDefinitionFromACatalog_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeploymentEnvironmentsClient client = new DeploymentEnvironmentsClient(endpoint, credential);

            Response response = await client.GetEnvironmentDefinitionAsync("myProject", "myCatalog", "foo", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("catalogName").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_EnvironmentDefinition_GetEnvironmentDefinition_GetAnEnvironmentDefinitionFromACatalog_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeploymentEnvironmentsClient client = new DeploymentEnvironmentsClient(endpoint, credential);

            Response<EnvironmentDefinition> response = client.GetEnvironmentDefinition("myProject", "myCatalog", "foo");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_EnvironmentDefinition_GetEnvironmentDefinition_GetAnEnvironmentDefinitionFromACatalog_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeploymentEnvironmentsClient client = new DeploymentEnvironmentsClient(endpoint, credential);

            Response<EnvironmentDefinition> response = await client.GetEnvironmentDefinitionAsync("myProject", "myCatalog", "foo");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_EnvironmentClientOperations_GetAllEnvironments_ListsTheEnvironmentsForAProject()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeploymentEnvironmentsClient client = new DeploymentEnvironmentsClient(endpoint, credential);

            foreach (BinaryData item in client.GetAllEnvironments("myProject", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("environmentType").ToString());
                Console.WriteLine(result.GetProperty("catalogName").ToString());
                Console.WriteLine(result.GetProperty("environmentDefinitionName").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_EnvironmentClientOperations_GetAllEnvironments_ListsTheEnvironmentsForAProject_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeploymentEnvironmentsClient client = new DeploymentEnvironmentsClient(endpoint, credential);

            await foreach (BinaryData item in client.GetAllEnvironmentsAsync("myProject", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("environmentType").ToString());
                Console.WriteLine(result.GetProperty("catalogName").ToString());
                Console.WriteLine(result.GetProperty("environmentDefinitionName").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_EnvironmentClientOperations_GetAllEnvironments_ListsTheEnvironmentsForAProject_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeploymentEnvironmentsClient client = new DeploymentEnvironmentsClient(endpoint, credential);

            foreach (DevCenterEnvironment item in client.GetAllEnvironments("myProject"))
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_EnvironmentClientOperations_GetAllEnvironments_ListsTheEnvironmentsForAProject_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeploymentEnvironmentsClient client = new DeploymentEnvironmentsClient(endpoint, credential);

            await foreach (DevCenterEnvironment item in client.GetAllEnvironmentsAsync("myProject"))
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_EnvironmentClientOperations_GetEnvironments_ListsTheEnvironmentsForAProjectAndUser()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeploymentEnvironmentsClient client = new DeploymentEnvironmentsClient(endpoint, credential);

            foreach (BinaryData item in client.GetEnvironments("myProject", "me", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("environmentType").ToString());
                Console.WriteLine(result.GetProperty("catalogName").ToString());
                Console.WriteLine(result.GetProperty("environmentDefinitionName").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_EnvironmentClientOperations_GetEnvironments_ListsTheEnvironmentsForAProjectAndUser_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeploymentEnvironmentsClient client = new DeploymentEnvironmentsClient(endpoint, credential);

            await foreach (BinaryData item in client.GetEnvironmentsAsync("myProject", "me", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("environmentType").ToString());
                Console.WriteLine(result.GetProperty("catalogName").ToString());
                Console.WriteLine(result.GetProperty("environmentDefinitionName").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_EnvironmentClientOperations_GetEnvironments_ListsTheEnvironmentsForAProjectAndUser_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeploymentEnvironmentsClient client = new DeploymentEnvironmentsClient(endpoint, credential);

            foreach (DevCenterEnvironment item in client.GetEnvironments("myProject", "me"))
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_EnvironmentClientOperations_GetEnvironments_ListsTheEnvironmentsForAProjectAndUser_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeploymentEnvironmentsClient client = new DeploymentEnvironmentsClient(endpoint, credential);

            await foreach (DevCenterEnvironment item in client.GetEnvironmentsAsync("myProject", "me"))
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Catalog_GetCatalogs_ListsAllOfTheCatalogsAvailableForAProject()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeploymentEnvironmentsClient client = new DeploymentEnvironmentsClient(endpoint, credential);

            foreach (BinaryData item in client.GetCatalogs("myProject", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("name").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Catalog_GetCatalogs_ListsAllOfTheCatalogsAvailableForAProject_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeploymentEnvironmentsClient client = new DeploymentEnvironmentsClient(endpoint, credential);

            await foreach (BinaryData item in client.GetCatalogsAsync("myProject", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("name").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Catalog_GetCatalogs_ListsAllOfTheCatalogsAvailableForAProject_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeploymentEnvironmentsClient client = new DeploymentEnvironmentsClient(endpoint, credential);

            foreach (DevCenterCatalog item in client.GetCatalogs("myProject"))
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Catalog_GetCatalogs_ListsAllOfTheCatalogsAvailableForAProject_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeploymentEnvironmentsClient client = new DeploymentEnvironmentsClient(endpoint, credential);

            await foreach (DevCenterCatalog item in client.GetCatalogsAsync("myProject"))
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_EnvironmentClientOperations_GetEnvironmentDefinitions_ListsAllEnvironmentDefinitionsAvailableForAProject()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeploymentEnvironmentsClient client = new DeploymentEnvironmentsClient(endpoint, credential);

            foreach (BinaryData item in client.GetEnvironmentDefinitions("myProject", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("catalogName").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_EnvironmentClientOperations_GetEnvironmentDefinitions_ListsAllEnvironmentDefinitionsAvailableForAProject_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeploymentEnvironmentsClient client = new DeploymentEnvironmentsClient(endpoint, credential);

            await foreach (BinaryData item in client.GetEnvironmentDefinitionsAsync("myProject", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("catalogName").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_EnvironmentClientOperations_GetEnvironmentDefinitions_ListsAllEnvironmentDefinitionsAvailableForAProject_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeploymentEnvironmentsClient client = new DeploymentEnvironmentsClient(endpoint, credential);

            foreach (EnvironmentDefinition item in client.GetEnvironmentDefinitions("myProject"))
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_EnvironmentClientOperations_GetEnvironmentDefinitions_ListsAllEnvironmentDefinitionsAvailableForAProject_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeploymentEnvironmentsClient client = new DeploymentEnvironmentsClient(endpoint, credential);

            await foreach (EnvironmentDefinition item in client.GetEnvironmentDefinitionsAsync("myProject"))
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_EnvironmentClientOperations_GetEnvironmentDefinitionsByCatalog_ListsAllEnvironmentDefinitionsAvailableWithinACatalog()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeploymentEnvironmentsClient client = new DeploymentEnvironmentsClient(endpoint, credential);

            foreach (BinaryData item in client.GetEnvironmentDefinitionsByCatalog("myProject", "myCatalog", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("catalogName").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_EnvironmentClientOperations_GetEnvironmentDefinitionsByCatalog_ListsAllEnvironmentDefinitionsAvailableWithinACatalog_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeploymentEnvironmentsClient client = new DeploymentEnvironmentsClient(endpoint, credential);

            await foreach (BinaryData item in client.GetEnvironmentDefinitionsByCatalogAsync("myProject", "myCatalog", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("catalogName").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_EnvironmentClientOperations_GetEnvironmentDefinitionsByCatalog_ListsAllEnvironmentDefinitionsAvailableWithinACatalog_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeploymentEnvironmentsClient client = new DeploymentEnvironmentsClient(endpoint, credential);

            foreach (EnvironmentDefinition item in client.GetEnvironmentDefinitionsByCatalog("myProject", "myCatalog"))
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_EnvironmentClientOperations_GetEnvironmentDefinitionsByCatalog_ListsAllEnvironmentDefinitionsAvailableWithinACatalog_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeploymentEnvironmentsClient client = new DeploymentEnvironmentsClient(endpoint, credential);

            await foreach (EnvironmentDefinition item in client.GetEnvironmentDefinitionsByCatalogAsync("myProject", "myCatalog"))
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_EnvironmentClientOperations_GetEnvironmentTypes_ListsAllEnvironmentTypesConfiguredForAProject()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeploymentEnvironmentsClient client = new DeploymentEnvironmentsClient(endpoint, credential);

            foreach (BinaryData item in client.GetEnvironmentTypes("myProject", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("deploymentTargetId").ToString());
                Console.WriteLine(result.GetProperty("status").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_EnvironmentClientOperations_GetEnvironmentTypes_ListsAllEnvironmentTypesConfiguredForAProject_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeploymentEnvironmentsClient client = new DeploymentEnvironmentsClient(endpoint, credential);

            await foreach (BinaryData item in client.GetEnvironmentTypesAsync("myProject", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("deploymentTargetId").ToString());
                Console.WriteLine(result.GetProperty("status").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_EnvironmentClientOperations_GetEnvironmentTypes_ListsAllEnvironmentTypesConfiguredForAProject_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeploymentEnvironmentsClient client = new DeploymentEnvironmentsClient(endpoint, credential);

            foreach (DevCenterEnvironmentType item in client.GetEnvironmentTypes("myProject"))
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_EnvironmentClientOperations_GetEnvironmentTypes_ListsAllEnvironmentTypesConfiguredForAProject_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeploymentEnvironmentsClient client = new DeploymentEnvironmentsClient(endpoint, credential);

            await foreach (DevCenterEnvironmentType item in client.GetEnvironmentTypesAsync("myProject"))
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_EnvironmentClientOperations_CreateOrUpdateEnvironment_CreatesOrUpdatesAnEnvironment()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeploymentEnvironmentsClient client = new DeploymentEnvironmentsClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                environmentType = "DevTest",
                catalogName = "main",
                environmentDefinitionName = "helloworld",
                parameters = new
                {
                    functionAppRuntime = "node",
                    storageAccountType = "Standard_LRS",
                },
            });
            Operation<BinaryData> operation = client.CreateOrUpdateEnvironment(WaitUntil.Completed, "myProject", "me", "mydevenv", content);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("environmentType").ToString());
            Console.WriteLine(result.GetProperty("catalogName").ToString());
            Console.WriteLine(result.GetProperty("environmentDefinitionName").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_EnvironmentClientOperations_CreateOrUpdateEnvironment_CreatesOrUpdatesAnEnvironment_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeploymentEnvironmentsClient client = new DeploymentEnvironmentsClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                environmentType = "DevTest",
                catalogName = "main",
                environmentDefinitionName = "helloworld",
                parameters = new
                {
                    functionAppRuntime = "node",
                    storageAccountType = "Standard_LRS",
                },
            });
            Operation<BinaryData> operation = await client.CreateOrUpdateEnvironmentAsync(WaitUntil.Completed, "myProject", "me", "mydevenv", content);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("environmentType").ToString());
            Console.WriteLine(result.GetProperty("catalogName").ToString());
            Console.WriteLine(result.GetProperty("environmentDefinitionName").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_EnvironmentClientOperations_DeleteEnvironment_DeletesAnEnvironmentAndAllItsAssociatedResources()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeploymentEnvironmentsClient client = new DeploymentEnvironmentsClient(endpoint, credential);

            Operation operation = client.DeleteEnvironment(WaitUntil.Completed, "myProject", "me", "mydevenv");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_EnvironmentClientOperations_DeleteEnvironment_DeletesAnEnvironmentAndAllItsAssociatedResources_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeploymentEnvironmentsClient client = new DeploymentEnvironmentsClient(endpoint, credential);

            Operation operation = await client.DeleteEnvironmentAsync(WaitUntil.Completed, "myProject", "me", "mydevenv");
        }
    }
}
