// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Developer.DevCenter.Models
{
    /// <summary> Indicates whether the feature to stop the devbox on disconnect once the grace period has lapsed is enabled. </summary>
    public readonly partial struct StopOnDisconnectStatus : IEquatable<StopOnDisconnectStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StopOnDisconnectStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StopOnDisconnectStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Stop on disconnect is enabled on the Dev Box. </summary>
        public static StopOnDisconnectStatus Enabled { get; } = new StopOnDisconnectStatus(EnabledValue);
        /// <summary> Stop on disconnect is not enabled on the Dev Box. </summary>
        public static StopOnDisconnectStatus Disabled { get; } = new StopOnDisconnectStatus(DisabledValue);
        /// <summary> Determines if two <see cref="StopOnDisconnectStatus"/> values are the same. </summary>
        public static bool operator ==(StopOnDisconnectStatus left, StopOnDisconnectStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StopOnDisconnectStatus"/> values are not the same. </summary>
        public static bool operator !=(StopOnDisconnectStatus left, StopOnDisconnectStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StopOnDisconnectStatus"/>. </summary>
        public static implicit operator StopOnDisconnectStatus(string value) => new StopOnDisconnectStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StopOnDisconnectStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StopOnDisconnectStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
