// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Developer.DevCenter.Models
{
    /// <summary> Indicates the Dev Box compute. </summary>
    public readonly partial struct SkuName : IEquatable<SkuName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SkuName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SkuName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string GeneralI8c32gb256ssdV2Value = "general_i_8c32gb256ssd_v2";
        private const string GeneralI8c32gb512ssdV2Value = "general_i_8c32gb512ssd_v2";
        private const string GeneralI8c32gb1024ssdV2Value = "general_i_8c32gb1024ssd_v2";
        private const string GeneralI8c32gb2048ssdV2Value = "general_i_8c32gb2048ssd_v2";
        private const string GeneralI16c64gb256ssdV2Value = "general_i_16c64gb256ssd_v2";
        private const string GeneralI16c64gb512ssdV2Value = "general_i_16c64gb512ssd_v2";
        private const string GeneralI16c64gb1024ssdV2Value = "general_i_16c64gb1024ssd_v2";
        private const string GeneralI16c64gb2048ssdV2Value = "general_i_16c64gb2048ssd_v2";
        private const string GeneralI32c128gb512ssdV2Value = "general_i_32c128gb512ssd_v2";
        private const string GeneralI32c128gb1024ssdV2Value = "general_i_32c128gb1024ssd_v2";
        private const string GeneralI32c128gb2048ssdV2Value = "general_i_32c128gb2048ssd_v2";
        private const string GeneralA8c32gb256ssdV2Value = "general_a_8c32gb256ssd_v2";
        private const string GeneralA8c32gb512ssdV2Value = "general_a_8c32gb512ssd_v2";
        private const string GeneralA8c32gb1024ssdV2Value = "general_a_8c32gb1024ssd_v2";
        private const string GeneralA8c32gb2048ssdV2Value = "general_a_8c32gb2048ssd_v2";
        private const string GeneralA16c64gb256ssdV2Value = "general_a_16c64gb256ssd_v2";
        private const string GeneralA16c64gb512ssdV2Value = "general_a_16c64gb512ssd_v2";
        private const string GeneralA16c64gb1024ssdV2Value = "general_a_16c64gb1024ssd_v2";
        private const string GeneralA16c64gb2048ssdV2Value = "general_a_16c64gb2048ssd_v2";
        private const string GeneralA32c128gb512ssdV2Value = "general_a_32c128gb512ssd_v2";
        private const string GeneralA32c128gb1024ssdV2Value = "general_a_32c128gb1024ssd_v2";
        private const string GeneralA32c128gb2048ssdV2Value = "general_a_32c128gb2048ssd_v2";

        /// <summary> Intel, 8 vCPU, 32 GB RAM, 256 GB Storage. </summary>
        public static SkuName GeneralI8c32gb256ssdV2 { get; } = new SkuName(GeneralI8c32gb256ssdV2Value);
        /// <summary> Intel, 8 vCPU, 32 GB RAM, 512 GB Storage. </summary>
        public static SkuName GeneralI8c32gb512ssdV2 { get; } = new SkuName(GeneralI8c32gb512ssdV2Value);
        /// <summary> Intel, 8 vCPU, 32 GB RAM, 1024 GB Storage. </summary>
        public static SkuName GeneralI8c32gb1024ssdV2 { get; } = new SkuName(GeneralI8c32gb1024ssdV2Value);
        /// <summary> Intel, 8 vCPU, 32 GB RAM, 2048 GB Storage. </summary>
        public static SkuName GeneralI8c32gb2048ssdV2 { get; } = new SkuName(GeneralI8c32gb2048ssdV2Value);
        /// <summary> Intel, 16 vCPU, 64 GB RAM, 256 GB Storage. </summary>
        public static SkuName GeneralI16c64gb256ssdV2 { get; } = new SkuName(GeneralI16c64gb256ssdV2Value);
        /// <summary> Intel, 16 vCPU, 64 GB RAM, 512 GB Storage. </summary>
        public static SkuName GeneralI16c64gb512ssdV2 { get; } = new SkuName(GeneralI16c64gb512ssdV2Value);
        /// <summary> Intel, 16 vCPU, 64 GB RAM, 1024 GB Storage. </summary>
        public static SkuName GeneralI16c64gb1024ssdV2 { get; } = new SkuName(GeneralI16c64gb1024ssdV2Value);
        /// <summary> Intel, 16 vCPU, 64 GB RAM, 2048 GB Storage. </summary>
        public static SkuName GeneralI16c64gb2048ssdV2 { get; } = new SkuName(GeneralI16c64gb2048ssdV2Value);
        /// <summary> Intel, 32 vCPU, 128 GB RAM, 512 GB Storage. </summary>
        public static SkuName GeneralI32c128gb512ssdV2 { get; } = new SkuName(GeneralI32c128gb512ssdV2Value);
        /// <summary> Intel, 32 vCPU, 128 GB RAM, 1024 GB Storage. </summary>
        public static SkuName GeneralI32c128gb1024ssdV2 { get; } = new SkuName(GeneralI32c128gb1024ssdV2Value);
        /// <summary> Intel, 32 vCPU, 128 GB RAM, 2048 GB Storage. </summary>
        public static SkuName GeneralI32c128gb2048ssdV2 { get; } = new SkuName(GeneralI32c128gb2048ssdV2Value);
        /// <summary> AMD, 8 vCPU, 32 GB RAM, 256 GB Storage. </summary>
        public static SkuName GeneralA8c32gb256ssdV2 { get; } = new SkuName(GeneralA8c32gb256ssdV2Value);
        /// <summary> AMD, 8 vCPU, 32 GB RAM, 512 GB Storage. </summary>
        public static SkuName GeneralA8c32gb512ssdV2 { get; } = new SkuName(GeneralA8c32gb512ssdV2Value);
        /// <summary> AMD, 8 vCPU, 32 GB RAM, 1024 GB Storage. </summary>
        public static SkuName GeneralA8c32gb1024ssdV2 { get; } = new SkuName(GeneralA8c32gb1024ssdV2Value);
        /// <summary> AMD, 8 vCPU, 32 GB RAM, 2048 GB Storage. </summary>
        public static SkuName GeneralA8c32gb2048ssdV2 { get; } = new SkuName(GeneralA8c32gb2048ssdV2Value);
        /// <summary> AMD, 16 vCPU, 64 GB RAM, 256 GB Storage. </summary>
        public static SkuName GeneralA16c64gb256ssdV2 { get; } = new SkuName(GeneralA16c64gb256ssdV2Value);
        /// <summary> AMD, 16 vCPU, 64 GB RAM, 512 GB Storage. </summary>
        public static SkuName GeneralA16c64gb512ssdV2 { get; } = new SkuName(GeneralA16c64gb512ssdV2Value);
        /// <summary> AMD, 16 vCPU, 64 GB RAM, 1024 GB Storage. </summary>
        public static SkuName GeneralA16c64gb1024ssdV2 { get; } = new SkuName(GeneralA16c64gb1024ssdV2Value);
        /// <summary> AMD, 16 vCPU, 64 GB RAM, 2048 GB Storage. </summary>
        public static SkuName GeneralA16c64gb2048ssdV2 { get; } = new SkuName(GeneralA16c64gb2048ssdV2Value);
        /// <summary> AMD, 32 vCPU, 128 GB RAM, 512 GB Storage. </summary>
        public static SkuName GeneralA32c128gb512ssdV2 { get; } = new SkuName(GeneralA32c128gb512ssdV2Value);
        /// <summary> AMD, 32 vCPU, 128 GB RAM, 1024 GB Storage. </summary>
        public static SkuName GeneralA32c128gb1024ssdV2 { get; } = new SkuName(GeneralA32c128gb1024ssdV2Value);
        /// <summary> AMD, 32 vCPU, 128 GB RAM, 2048 GB Storage. </summary>
        public static SkuName GeneralA32c128gb2048ssdV2 { get; } = new SkuName(GeneralA32c128gb2048ssdV2Value);
        /// <summary> Determines if two <see cref="SkuName"/> values are the same. </summary>
        public static bool operator ==(SkuName left, SkuName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SkuName"/> values are not the same. </summary>
        public static bool operator !=(SkuName left, SkuName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SkuName"/>. </summary>
        public static implicit operator SkuName(string value) => new SkuName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SkuName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SkuName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
