// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Developer.DevCenter.Models
{
    /// <summary> The supported types for a scheduled task. </summary>
    public readonly partial struct ScheduleType : IEquatable<ScheduleType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ScheduleType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ScheduleType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StopDevBoxValue = "StopDevBox";

        /// <summary> The scheduled task will stop impacted Dev Boxes. </summary>
        public static ScheduleType StopDevBox { get; } = new ScheduleType(StopDevBoxValue);
        /// <summary> Determines if two <see cref="ScheduleType"/> values are the same. </summary>
        public static bool operator ==(ScheduleType left, ScheduleType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ScheduleType"/> values are not the same. </summary>
        public static bool operator !=(ScheduleType left, ScheduleType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ScheduleType"/>. </summary>
        public static implicit operator ScheduleType(string value) => new ScheduleType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ScheduleType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ScheduleType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
