// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Developer.DevCenter.Models
{
    /// <summary> The power states of a Dev Box. </summary>
    public readonly partial struct PowerState : IEquatable<PowerState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PowerState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PowerState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string RunningValue = "Running";
        private const string DeallocatedValue = "Deallocated";
        private const string PoweredOffValue = "PoweredOff";
        private const string HibernatedValue = "Hibernated";

        /// <summary> The Dev Box power state is not known. </summary>
        public static PowerState Unknown { get; } = new PowerState(UnknownValue);
        /// <summary> The Dev Box is running. </summary>
        public static PowerState Running { get; } = new PowerState(RunningValue);
        /// <summary> The Dev Box is deallocated. </summary>
        public static PowerState Deallocated { get; } = new PowerState(DeallocatedValue);
        /// <summary> The Dev Box is powered off. </summary>
        public static PowerState PoweredOff { get; } = new PowerState(PoweredOffValue);
        /// <summary> The Dev Box is hibernated. </summary>
        public static PowerState Hibernated { get; } = new PowerState(HibernatedValue);
        /// <summary> Determines if two <see cref="PowerState"/> values are the same. </summary>
        public static bool operator ==(PowerState left, PowerState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PowerState"/> values are not the same. </summary>
        public static bool operator !=(PowerState left, PowerState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PowerState"/>. </summary>
        public static implicit operator PowerState(string value) => new PowerState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PowerState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PowerState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
