// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Developer.DevCenter.Models
{
    /// <summary> Pool status indicating whether a pool is available to create Dev Boxes. </summary>
    public readonly partial struct PoolHealthStatus : IEquatable<PoolHealthStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PoolHealthStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PoolHealthStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string PendingValue = "Pending";
        private const string HealthyValue = "Healthy";
        private const string WarningValue = "Warning";
        private const string UnhealthyValue = "Unhealthy";

        /// <summary> The pool health status is not known. </summary>
        public static PoolHealthStatus Unknown { get; } = new PoolHealthStatus(UnknownValue);
        /// <summary> The pool health status waiting for health checks to run. </summary>
        public static PoolHealthStatus Pending { get; } = new PoolHealthStatus(PendingValue);
        /// <summary> The pool health status is healthy. </summary>
        public static PoolHealthStatus Healthy { get; } = new PoolHealthStatus(HealthyValue);
        /// <summary> The pool health status has one or more warnings. </summary>
        public static PoolHealthStatus Warning { get; } = new PoolHealthStatus(WarningValue);
        /// <summary> The pool health status is not healthy. </summary>
        public static PoolHealthStatus Unhealthy { get; } = new PoolHealthStatus(UnhealthyValue);
        /// <summary> Determines if two <see cref="PoolHealthStatus"/> values are the same. </summary>
        public static bool operator ==(PoolHealthStatus left, PoolHealthStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PoolHealthStatus"/> values are not the same. </summary>
        public static bool operator !=(PoolHealthStatus left, PoolHealthStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PoolHealthStatus"/>. </summary>
        public static implicit operator PoolHealthStatus(string value) => new PoolHealthStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PoolHealthStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PoolHealthStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
