// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Developer.DevCenter.Models
{
    /// <summary> Indicates whether owners of Dev Boxes in a pool are local administrators on the Dev Boxes. </summary>
    public readonly partial struct LocalAdministratorStatus : IEquatable<LocalAdministratorStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LocalAdministratorStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LocalAdministratorStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Owners of Dev Boxes in the pool are local administrators on the Dev Boxes. </summary>
        public static LocalAdministratorStatus Enabled { get; } = new LocalAdministratorStatus(EnabledValue);
        /// <summary> Owners of Dev Boxes in the pool are not local administrators on the Dev Boxes. </summary>
        public static LocalAdministratorStatus Disabled { get; } = new LocalAdministratorStatus(DisabledValue);
        /// <summary> Determines if two <see cref="LocalAdministratorStatus"/> values are the same. </summary>
        public static bool operator ==(LocalAdministratorStatus left, LocalAdministratorStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LocalAdministratorStatus"/> values are not the same. </summary>
        public static bool operator !=(LocalAdministratorStatus left, LocalAdministratorStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LocalAdministratorStatus"/>. </summary>
        public static implicit operator LocalAdministratorStatus(string value) => new LocalAdministratorStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LocalAdministratorStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LocalAdministratorStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
