// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Developer.DevCenter.Models
{
    /// <summary> Indicates whether an environment type is enabled for use in a project. </summary>
    public readonly partial struct EnvironmentTypeStatus : IEquatable<EnvironmentTypeStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EnvironmentTypeStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EnvironmentTypeStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> The environment type is enabled for use in the project. </summary>
        public static EnvironmentTypeStatus Enabled { get; } = new EnvironmentTypeStatus(EnabledValue);
        /// <summary> The environment type is not enabled for use in the project. </summary>
        public static EnvironmentTypeStatus Disabled { get; } = new EnvironmentTypeStatus(DisabledValue);
        /// <summary> Determines if two <see cref="EnvironmentTypeStatus"/> values are the same. </summary>
        public static bool operator ==(EnvironmentTypeStatus left, EnvironmentTypeStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EnvironmentTypeStatus"/> values are not the same. </summary>
        public static bool operator !=(EnvironmentTypeStatus left, EnvironmentTypeStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EnvironmentTypeStatus"/>. </summary>
        public static implicit operator EnvironmentTypeStatus(string value) => new EnvironmentTypeStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EnvironmentTypeStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EnvironmentTypeStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
