// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Developer.DevCenter.Models
{
    /// <summary> The type of data a parameter accepts. </summary>
    public readonly partial struct EnvironmentDefinitionParameterType : IEquatable<EnvironmentDefinitionParameterType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EnvironmentDefinitionParameterType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EnvironmentDefinitionParameterType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ArrayValue = "array";
        private const string BooleanValue = "boolean";
        private const string IntegerValue = "integer";
        private const string NumberValue = "number";
        private const string ObjectValue = "object";
        private const string StringValue = "string";

        /// <summary> The parameter accepts an array of values. </summary>
        public static EnvironmentDefinitionParameterType Array { get; } = new EnvironmentDefinitionParameterType(ArrayValue);
        /// <summary> The parameter accepts a boolean value. </summary>
        public static EnvironmentDefinitionParameterType Boolean { get; } = new EnvironmentDefinitionParameterType(BooleanValue);
        /// <summary> The parameter accepts an integer value. </summary>
        public static EnvironmentDefinitionParameterType Integer { get; } = new EnvironmentDefinitionParameterType(IntegerValue);
        /// <summary> The parameter accepts a number value. </summary>
        public static EnvironmentDefinitionParameterType Number { get; } = new EnvironmentDefinitionParameterType(NumberValue);
        /// <summary> The parameter accepts an object value. </summary>
        public static EnvironmentDefinitionParameterType Object { get; } = new EnvironmentDefinitionParameterType(ObjectValue);
        /// <summary> The parameter accepts a string value. </summary>
        public static EnvironmentDefinitionParameterType String { get; } = new EnvironmentDefinitionParameterType(StringValue);
        /// <summary> Determines if two <see cref="EnvironmentDefinitionParameterType"/> values are the same. </summary>
        public static bool operator ==(EnvironmentDefinitionParameterType left, EnvironmentDefinitionParameterType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EnvironmentDefinitionParameterType"/> values are not the same. </summary>
        public static bool operator !=(EnvironmentDefinitionParameterType left, EnvironmentDefinitionParameterType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EnvironmentDefinitionParameterType"/>. </summary>
        public static implicit operator EnvironmentDefinitionParameterType(string value) => new EnvironmentDefinitionParameterType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EnvironmentDefinitionParameterType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EnvironmentDefinitionParameterType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
