// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Developer.DevCenter.Models
{
    /// <summary> An environment definition. </summary>
    public partial class EnvironmentDefinition
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EnvironmentDefinition"/>. </summary>
        /// <param name="id"> The ID of the environment definition. </param>
        /// <param name="catalogName"> Name of the catalog. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/> or <paramref name="catalogName"/> is null. </exception>
        internal EnvironmentDefinition(string id, string catalogName)
        {
            Argument.AssertNotNull(id, nameof(id));
            Argument.AssertNotNull(catalogName, nameof(catalogName));

            Id = id;
            CatalogName = catalogName;
            Parameters = new ChangeTrackingList<EnvironmentDefinitionParameter>();
        }

        /// <summary> Initializes a new instance of <see cref="EnvironmentDefinition"/>. </summary>
        /// <param name="id"> The ID of the environment definition. </param>
        /// <param name="name"> Name of the environment definition. </param>
        /// <param name="catalogName"> Name of the catalog. </param>
        /// <param name="description"> A short description of the environment definition. </param>
        /// <param name="parameters"> Input parameters passed to an environment. </param>
        /// <param name="parametersSchema"> JSON schema defining the parameters object passed to an environment. </param>
        /// <param name="templatePath"> Path to the Environment Definition entrypoint file. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EnvironmentDefinition(string id, string name, string catalogName, string description, IReadOnlyList<EnvironmentDefinitionParameter> parameters, string parametersSchema, string templatePath, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            Name = name;
            CatalogName = catalogName;
            Description = description;
            Parameters = parameters;
            ParametersSchema = parametersSchema;
            TemplatePath = templatePath;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="EnvironmentDefinition"/> for deserialization. </summary>
        internal EnvironmentDefinition()
        {
        }

        /// <summary> The ID of the environment definition. </summary>
        public string Id { get; }
        /// <summary> Name of the environment definition. </summary>
        public string Name { get; }
        /// <summary> Name of the catalog. </summary>
        public string CatalogName { get; }
        /// <summary> A short description of the environment definition. </summary>
        public string Description { get; }
        /// <summary> Input parameters passed to an environment. </summary>
        public IReadOnlyList<EnvironmentDefinitionParameter> Parameters { get; }
        /// <summary> JSON schema defining the parameters object passed to an environment. </summary>
        public string ParametersSchema { get; }
        /// <summary> Path to the Environment Definition entrypoint file. </summary>
        public string TemplatePath { get; }
    }
}
