// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.Developer.DevCenter.Models
{
    /// <summary> Properties of an environment type. </summary>
    public partial class DevCenterEnvironmentType
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DevCenterEnvironmentType"/>. </summary>
        /// <param name="name"> Name of the environment type. </param>
        /// <param name="deploymentTargetId">
        /// Id of a subscription or management group that the environment type will be
        /// mapped to. The environment's resources will be deployed into this subscription
        /// or management group.
        /// </param>
        /// <param name="status"> Indicates whether this environment type is enabled for use in this project. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> or <paramref name="deploymentTargetId"/> is null. </exception>
        internal DevCenterEnvironmentType(string name, ResourceIdentifier deploymentTargetId, EnvironmentTypeStatus status)
        {
            Argument.AssertNotNull(name, nameof(name));
            Argument.AssertNotNull(deploymentTargetId, nameof(deploymentTargetId));

            Name = name;
            DeploymentTargetId = deploymentTargetId;
            Status = status;
        }

        /// <summary> Initializes a new instance of <see cref="DevCenterEnvironmentType"/>. </summary>
        /// <param name="name"> Name of the environment type. </param>
        /// <param name="deploymentTargetId">
        /// Id of a subscription or management group that the environment type will be
        /// mapped to. The environment's resources will be deployed into this subscription
        /// or management group.
        /// </param>
        /// <param name="status"> Indicates whether this environment type is enabled for use in this project. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DevCenterEnvironmentType(string name, ResourceIdentifier deploymentTargetId, EnvironmentTypeStatus status, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            DeploymentTargetId = deploymentTargetId;
            Status = status;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DevCenterEnvironmentType"/> for deserialization. </summary>
        internal DevCenterEnvironmentType()
        {
        }

        /// <summary> Name of the environment type. </summary>
        public string Name { get; }
        /// <summary> Indicates whether this environment type is enabled for use in this project. </summary>
        public EnvironmentTypeStatus Status { get; }
    }
}
