// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Developer.DevCenter.Models
{
    /// <summary> A Schedule to execute action. </summary>
    public partial class DevBoxSchedule
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DevBoxSchedule"/>. </summary>
        /// <param name="scheduleType"> Supported type this scheduled task represents. </param>
        /// <param name="scheduleFrequency"> The frequency of this scheduled task. </param>
        /// <param name="time"> The target time to trigger the action. The format is HH:MM. </param>
        /// <param name="timeZone"> The IANA timezone id at which the schedule should execute. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="time"/> or <paramref name="timeZone"/> is null. </exception>
        internal DevBoxSchedule(ScheduleType scheduleType, ScheduleFrequency scheduleFrequency, string time, string timeZone)
        {
            Argument.AssertNotNull(time, nameof(time));
            Argument.AssertNotNull(timeZone, nameof(timeZone));

            ScheduleType = scheduleType;
            ScheduleFrequency = scheduleFrequency;
            Time = time;
            TimeZone = timeZone;
        }

        /// <summary> Initializes a new instance of <see cref="DevBoxSchedule"/>. </summary>
        /// <param name="name"> Display name for the Schedule. </param>
        /// <param name="scheduleType"> Supported type this scheduled task represents. </param>
        /// <param name="scheduleFrequency"> The frequency of this scheduled task. </param>
        /// <param name="time"> The target time to trigger the action. The format is HH:MM. </param>
        /// <param name="timeZone"> The IANA timezone id at which the schedule should execute. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DevBoxSchedule(string name, ScheduleType scheduleType, ScheduleFrequency scheduleFrequency, string time, string timeZone, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            ScheduleType = scheduleType;
            ScheduleFrequency = scheduleFrequency;
            Time = time;
            TimeZone = timeZone;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DevBoxSchedule"/> for deserialization. </summary>
        internal DevBoxSchedule()
        {
        }

        /// <summary> Display name for the Schedule. </summary>
        public string Name { get; }
        /// <summary> Supported type this scheduled task represents. </summary>
        public ScheduleType ScheduleType { get; }
        /// <summary> The frequency of this scheduled task. </summary>
        public ScheduleFrequency ScheduleFrequency { get; }
        /// <summary> The target time to trigger the action. The format is HH:MM. </summary>
        public string Time { get; }
        /// <summary> The IANA timezone id at which the schedule should execute. </summary>
        public string TimeZone { get; }
    }
}
