// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Developer.DevCenter.Models
{
    /// <summary> The operating system type. </summary>
    public readonly partial struct DevBoxOSType : IEquatable<DevBoxOSType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DevBoxOSType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DevBoxOSType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string WindowsValue = "Windows";

        /// <summary> The Windows operating system. </summary>
        public static DevBoxOSType Windows { get; } = new DevBoxOSType(WindowsValue);
        /// <summary> Determines if two <see cref="DevBoxOSType"/> values are the same. </summary>
        public static bool operator ==(DevBoxOSType left, DevBoxOSType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DevBoxOSType"/> values are not the same. </summary>
        public static bool operator !=(DevBoxOSType left, DevBoxOSType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DevBoxOSType"/>. </summary>
        public static implicit operator DevBoxOSType(string value) => new DevBoxOSType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DevBoxOSType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DevBoxOSType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
