// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Developer.DevCenter.Models
{
    /// <summary> Details about the next run of an action. </summary>
    public partial class DevBoxNextAction
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DevBoxNextAction"/>. </summary>
        /// <param name="scheduledTime"> The time the action will be triggered (UTC). </param>
        internal DevBoxNextAction(DateTimeOffset scheduledTime)
        {
            ScheduledTime = scheduledTime;
        }

        /// <summary> Initializes a new instance of <see cref="DevBoxNextAction"/>. </summary>
        /// <param name="scheduledTime"> The time the action will be triggered (UTC). </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DevBoxNextAction(DateTimeOffset scheduledTime, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ScheduledTime = scheduledTime;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DevBoxNextAction"/> for deserialization. </summary>
        internal DevBoxNextAction()
        {
        }

        /// <summary> The time the action will be triggered (UTC). </summary>
        public DateTimeOffset ScheduledTime { get; }
    }
}
