// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Developer.DevCenter.Models
{
    /// <summary> Specifies information about the image used. </summary>
    public partial class DevBoxImageReference
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DevBoxImageReference"/>. </summary>
        public DevBoxImageReference()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DevBoxImageReference"/>. </summary>
        /// <param name="name"> The name of the image used. </param>
        /// <param name="version"> The version of the image. </param>
        /// <param name="operatingSystem"> The operating system of the image. </param>
        /// <param name="osBuildNumber"> The operating system build number of the image. </param>
        /// <param name="publishedDate"> The datetime that the backing image version was published. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DevBoxImageReference(string name, string version, string operatingSystem, string osBuildNumber, DateTimeOffset? publishedDate, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Version = version;
            OperatingSystem = operatingSystem;
            OSBuildNumber = osBuildNumber;
            PublishedDate = publishedDate;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The name of the image used. </summary>
        public string Name { get; }
        /// <summary> The version of the image. </summary>
        public string Version { get; }
        /// <summary> The operating system of the image. </summary>
        public string OperatingSystem { get; }
        /// <summary> The operating system build number of the image. </summary>
        public string OSBuildNumber { get; }
        /// <summary> The datetime that the backing image version was published. </summary>
        public DateTimeOffset? PublishedDate { get; }
    }
}
