// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Developer.DevCenter.Models
{
    /// <summary> Hardware specifications for the Dev Box. </summary>
    public partial class DevBoxHardwareProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DevBoxHardwareProfile"/>. </summary>
        public DevBoxHardwareProfile()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DevBoxHardwareProfile"/>. </summary>
        /// <param name="skuName"> The name of the SKU. </param>
        /// <param name="vcpUs"> The number of vCPUs available for the Dev Box. </param>
        /// <param name="memoryGB"> The amount of memory available for the Dev Box. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DevBoxHardwareProfile(SkuName? skuName, int? vcpUs, int? memoryGB, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SkuName = skuName;
            VCPUs = vcpUs;
            MemoryGB = memoryGB;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The name of the SKU. </summary>
        public SkuName? SkuName { get; }
        /// <summary> The number of vCPUs available for the Dev Box. </summary>
        public int? VCPUs { get; }
        /// <summary> The amount of memory available for the Dev Box. </summary>
        public int? MemoryGB { get; }
    }
}
