// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.Developer.DevCenter.Models
{
    /// <summary> A Dev Box. </summary>
    public partial class DevBox
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DevBox"/>. </summary>
        /// <param name="name"> Display name for the Dev Box. </param>
        /// <param name="projectName"> Name of the project this Dev Box belongs to. </param>
        /// <param name="poolName"> The name of the Dev Box pool this machine belongs to. </param>
        /// <param name="hibernateSupport"> Indicates whether hibernate is enabled/disabled or unknown. </param>
        /// <param name="provisioningState"> The current provisioning state of the Dev Box. </param>
        /// <param name="actionState">
        /// The current action state of the Dev Box. This is state is based on previous
        /// action performed by user.
        /// </param>
        /// <param name="powerState"> The current power state of the Dev Box. </param>
        /// <param name="uniqueId">
        /// A unique identifier for the Dev Box. This is a GUID-formatted string (e.g.
        /// 00000000-0000-0000-0000-000000000000).
        /// </param>
        /// <param name="error"> Provisioning or action error details. Populated only for error states. </param>
        /// <param name="location">
        /// Azure region where this Dev Box is located. This will be the same region as the
        /// Virtual Network it is attached to.
        /// </param>
        /// <param name="osType"> The operating system type of this Dev Box. </param>
        /// <param name="userId"> The AAD object id of the user this Dev Box is assigned to. </param>
        /// <param name="hardwareProfile"> Information about the Dev Box's hardware resources. </param>
        /// <param name="storageProfile"> Storage settings for this Dev Box. </param>
        /// <param name="imageReference"> Information about the image used for this Dev Box. </param>
        /// <param name="createdTime"> Creation time of this Dev Box. </param>
        /// <param name="localAdministratorStatus"> Indicates whether the owner of the Dev Box is a local administrator. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DevBox(string name, string projectName, string poolName, HibernateSupport? hibernateSupport, DevBoxProvisioningState? provisioningState, string actionState, PowerState? powerState, Guid? uniqueId, ResponseError error, AzureLocation? location, DevBoxOSType? osType, Guid? userId, DevBoxHardwareProfile hardwareProfile, DevBoxStorageProfile storageProfile, DevBoxImageReference imageReference, DateTimeOffset? createdTime, LocalAdministratorStatus? localAdministratorStatus, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            ProjectName = projectName;
            PoolName = poolName;
            HibernateSupport = hibernateSupport;
            ProvisioningState = provisioningState;
            ActionState = actionState;
            PowerState = powerState;
            UniqueId = uniqueId;
            Error = error;
            Location = location;
            OSType = osType;
            UserId = userId;
            HardwareProfile = hardwareProfile;
            StorageProfile = storageProfile;
            ImageReference = imageReference;
            CreatedTime = createdTime;
            LocalAdministratorStatus = localAdministratorStatus;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DevBox"/> for deserialization. </summary>
        internal DevBox()
        {
        }

        /// <summary> Display name for the Dev Box. </summary>
        public string Name { get; }
        /// <summary> Name of the project this Dev Box belongs to. </summary>
        public string ProjectName { get; }
        /// <summary> The name of the Dev Box pool this machine belongs to. </summary>
        public string PoolName { get; set; }
        /// <summary> Indicates whether hibernate is enabled/disabled or unknown. </summary>
        public HibernateSupport? HibernateSupport { get; }
        /// <summary> The current provisioning state of the Dev Box. </summary>
        public DevBoxProvisioningState? ProvisioningState { get; }
        /// <summary>
        /// The current action state of the Dev Box. This is state is based on previous
        /// action performed by user.
        /// </summary>
        public string ActionState { get; }
        /// <summary> The current power state of the Dev Box. </summary>
        public PowerState? PowerState { get; }
        /// <summary>
        /// A unique identifier for the Dev Box. This is a GUID-formatted string (e.g.
        /// 00000000-0000-0000-0000-000000000000).
        /// </summary>
        public Guid? UniqueId { get; }
        /// <summary> Provisioning or action error details. Populated only for error states. </summary>
        public ResponseError Error { get; }
        /// <summary>
        /// Azure region where this Dev Box is located. This will be the same region as the
        /// Virtual Network it is attached to.
        /// </summary>
        public AzureLocation? Location { get; }
        /// <summary> The operating system type of this Dev Box. </summary>
        public DevBoxOSType? OSType { get; }
        /// <summary> The AAD object id of the user this Dev Box is assigned to. </summary>
        public Guid? UserId { get; }
        /// <summary> Information about the Dev Box's hardware resources. </summary>
        public DevBoxHardwareProfile HardwareProfile { get; }
        /// <summary> Storage settings for this Dev Box. </summary>
        public DevBoxStorageProfile StorageProfile { get; }
        /// <summary> Information about the image used for this Dev Box. </summary>
        public DevBoxImageReference ImageReference { get; }
        /// <summary> Creation time of this Dev Box. </summary>
        public DateTimeOffset? CreatedTime { get; }
        /// <summary> Indicates whether the owner of the Dev Box is a local administrator. </summary>
        public LocalAdministratorStatus? LocalAdministratorStatus { get; set; }
    }
}
