// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DesktopVirtualization.Models
{
    /// <summary> Specifies whether this published application can be launched with command line arguments provided by the client, command line arguments specified at publish time, or no command line arguments at all. </summary>
    public readonly partial struct VirtualApplicationCommandLineSetting : IEquatable<VirtualApplicationCommandLineSetting>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VirtualApplicationCommandLineSetting"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VirtualApplicationCommandLineSetting(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DoNotAllowValue = "DoNotAllow";
        private const string AllowValue = "Allow";
        private const string RequireValue = "Require";

        /// <summary> DoNotAllow. </summary>
        public static VirtualApplicationCommandLineSetting DoNotAllow { get; } = new VirtualApplicationCommandLineSetting(DoNotAllowValue);
        /// <summary> Allow. </summary>
        public static VirtualApplicationCommandLineSetting Allow { get; } = new VirtualApplicationCommandLineSetting(AllowValue);
        /// <summary> Require. </summary>
        public static VirtualApplicationCommandLineSetting Require { get; } = new VirtualApplicationCommandLineSetting(RequireValue);
        /// <summary> Determines if two <see cref="VirtualApplicationCommandLineSetting"/> values are the same. </summary>
        public static bool operator ==(VirtualApplicationCommandLineSetting left, VirtualApplicationCommandLineSetting right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VirtualApplicationCommandLineSetting"/> values are not the same. </summary>
        public static bool operator !=(VirtualApplicationCommandLineSetting left, VirtualApplicationCommandLineSetting right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VirtualApplicationCommandLineSetting"/>. </summary>
        public static implicit operator VirtualApplicationCommandLineSetting(string value) => new VirtualApplicationCommandLineSetting(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VirtualApplicationCommandLineSetting other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VirtualApplicationCommandLineSetting other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
