// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DesktopVirtualization.Models
{
    /// <summary> State of user session. </summary>
    public readonly partial struct UserSessionState : IEquatable<UserSessionState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="UserSessionState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public UserSessionState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string ActiveValue = "Active";
        private const string DisconnectedValue = "Disconnected";
        private const string PendingValue = "Pending";
        private const string LogOffValue = "LogOff";
        private const string UserProfileDiskMountedValue = "UserProfileDiskMounted";

        /// <summary> Unknown. </summary>
        public static UserSessionState Unknown { get; } = new UserSessionState(UnknownValue);
        /// <summary> Active. </summary>
        public static UserSessionState Active { get; } = new UserSessionState(ActiveValue);
        /// <summary> Disconnected. </summary>
        public static UserSessionState Disconnected { get; } = new UserSessionState(DisconnectedValue);
        /// <summary> Pending. </summary>
        public static UserSessionState Pending { get; } = new UserSessionState(PendingValue);
        /// <summary> LogOff. </summary>
        public static UserSessionState LogOff { get; } = new UserSessionState(LogOffValue);
        /// <summary> UserProfileDiskMounted. </summary>
        public static UserSessionState UserProfileDiskMounted { get; } = new UserSessionState(UserProfileDiskMountedValue);
        /// <summary> Determines if two <see cref="UserSessionState"/> values are the same. </summary>
        public static bool operator ==(UserSessionState left, UserSessionState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="UserSessionState"/> values are not the same. </summary>
        public static bool operator !=(UserSessionState left, UserSessionState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="UserSessionState"/>. </summary>
        public static implicit operator UserSessionState(string value) => new UserSessionState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is UserSessionState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(UserSessionState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
