// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DesktopVirtualization.Models
{
    /// <summary> Update state of a SessionHost. </summary>
    public readonly partial struct SessionHostUpdateState : IEquatable<SessionHostUpdateState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SessionHostUpdateState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SessionHostUpdateState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InitialValue = "Initial";
        private const string PendingValue = "Pending";
        private const string StartedValue = "Started";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";

        /// <summary> Initial. </summary>
        public static SessionHostUpdateState Initial { get; } = new SessionHostUpdateState(InitialValue);
        /// <summary> Pending. </summary>
        public static SessionHostUpdateState Pending { get; } = new SessionHostUpdateState(PendingValue);
        /// <summary> Started. </summary>
        public static SessionHostUpdateState Started { get; } = new SessionHostUpdateState(StartedValue);
        /// <summary> Succeeded. </summary>
        public static SessionHostUpdateState Succeeded { get; } = new SessionHostUpdateState(SucceededValue);
        /// <summary> Failed. </summary>
        public static SessionHostUpdateState Failed { get; } = new SessionHostUpdateState(FailedValue);
        /// <summary> Determines if two <see cref="SessionHostUpdateState"/> values are the same. </summary>
        public static bool operator ==(SessionHostUpdateState left, SessionHostUpdateState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SessionHostUpdateState"/> values are not the same. </summary>
        public static bool operator !=(SessionHostUpdateState left, SessionHostUpdateState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SessionHostUpdateState"/>. </summary>
        public static implicit operator SessionHostUpdateState(string value) => new SessionHostUpdateState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SessionHostUpdateState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SessionHostUpdateState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
