// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DesktopVirtualization.Models
{
    /// <summary> Status for a SessionHost. </summary>
    public readonly partial struct SessionHostStatus : IEquatable<SessionHostStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SessionHostStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SessionHostStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AvailableValue = "Available";
        private const string UnavailableValue = "Unavailable";
        private const string ShutdownValue = "Shutdown";
        private const string DisconnectedValue = "Disconnected";
        private const string UpgradingValue = "Upgrading";
        private const string UpgradeFailedValue = "UpgradeFailed";
        private const string NoHeartbeatValue = "NoHeartbeat";
        private const string NotJoinedToDomainValue = "NotJoinedToDomain";
        private const string DomainTrustRelationshipLostValue = "DomainTrustRelationshipLost";
        private const string SxsStackListenerNotReadyValue = "SxSStackListenerNotReady";
        private const string FSLogixNotHealthyValue = "FSLogixNotHealthy";
        private const string NeedsAssistanceValue = "NeedsAssistance";

        /// <summary> Session Host has passed all the health checks and is available to handle connections. </summary>
        public static SessionHostStatus Available { get; } = new SessionHostStatus(AvailableValue);
        /// <summary> Session Host is either turned off or has failed critical health checks which is causing service not to be able to route connections to this session host. Note this replaces previous 'NoHeartBeat' status. </summary>
        public static SessionHostStatus Unavailable { get; } = new SessionHostStatus(UnavailableValue);
        /// <summary> Session Host is shutdown - RD Agent reported session host to be stopped or deallocated. </summary>
        public static SessionHostStatus Shutdown { get; } = new SessionHostStatus(ShutdownValue);
        /// <summary> The Session Host is unavailable because it is currently disconnected. </summary>
        public static SessionHostStatus Disconnected { get; } = new SessionHostStatus(DisconnectedValue);
        /// <summary> Session Host is unavailable because currently an upgrade of RDAgent/side-by-side stack is in progress. Note: this state will be removed once the upgrade completes and the host is able to accept connections. </summary>
        public static SessionHostStatus Upgrading { get; } = new SessionHostStatus(UpgradingValue);
        /// <summary> Session Host is unavailable because the critical component upgrade (agent, side-by-side stack, etc.) failed. </summary>
        public static SessionHostStatus UpgradeFailed { get; } = new SessionHostStatus(UpgradeFailedValue);
        /// <summary> The Session Host is not heart beating. </summary>
        public static SessionHostStatus NoHeartbeat { get; } = new SessionHostStatus(NoHeartbeatValue);
        /// <summary> SessionHost is not joined to domain. </summary>
        public static SessionHostStatus NotJoinedToDomain { get; } = new SessionHostStatus(NotJoinedToDomainValue);
        /// <summary> SessionHost's domain trust relationship lost. </summary>
        public static SessionHostStatus DomainTrustRelationshipLost { get; } = new SessionHostStatus(DomainTrustRelationshipLostValue);
        /// <summary> SxS stack installed on the SessionHost is not ready to receive connections. </summary>
        public static SessionHostStatus SxsStackListenerNotReady { get; } = new SessionHostStatus(SxsStackListenerNotReadyValue);
        /// <summary> FSLogix is in an unhealthy state on the session host. </summary>
        public static SessionHostStatus FSLogixNotHealthy { get; } = new SessionHostStatus(FSLogixNotHealthyValue);
        /// <summary> New status to inform admins that the health on their endpoint needs to be fixed. The connections might not fail, as these issues are not fatal. </summary>
        public static SessionHostStatus NeedsAssistance { get; } = new SessionHostStatus(NeedsAssistanceValue);
        /// <summary> Determines if two <see cref="SessionHostStatus"/> values are the same. </summary>
        public static bool operator ==(SessionHostStatus left, SessionHostStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SessionHostStatus"/> values are not the same. </summary>
        public static bool operator !=(SessionHostStatus left, SessionHostStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SessionHostStatus"/>. </summary>
        public static implicit operator SessionHostStatus(string value) => new SessionHostStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SessionHostStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SessionHostStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
