// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DesktopVirtualization.Models
{
    /// <summary> The report for session host information. </summary>
    public partial class SessionHostHealthCheckReport
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SessionHostHealthCheckReport"/>. </summary>
        internal SessionHostHealthCheckReport()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SessionHostHealthCheckReport"/>. </summary>
        /// <param name="healthCheckName"> Represents the name of the health check operation performed. </param>
        /// <param name="healthCheckResult"> Represents the Health state of the health check we performed. </param>
        /// <param name="additionalFailureDetails"> Additional detailed information on the failure. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SessionHostHealthCheckReport(SessionHostHealthCheckName? healthCheckName, SessionHostHealthCheckResult? healthCheckResult, SessionHostHealthCheckFailureDetails additionalFailureDetails, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            HealthCheckName = healthCheckName;
            HealthCheckResult = healthCheckResult;
            AdditionalFailureDetails = additionalFailureDetails;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Represents the name of the health check operation performed. </summary>
        [WirePath("healthCheckName")]
        public SessionHostHealthCheckName? HealthCheckName { get; }
        /// <summary> Represents the Health state of the health check we performed. </summary>
        [WirePath("healthCheckResult")]
        public SessionHostHealthCheckResult? HealthCheckResult { get; }
        /// <summary> Additional detailed information on the failure. </summary>
        [WirePath("additionalFailureDetails")]
        public SessionHostHealthCheckFailureDetails AdditionalFailureDetails { get; }
    }
}
