// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DesktopVirtualization.Models
{
    /// <summary> Contains details on the failure. </summary>
    public partial class SessionHostHealthCheckFailureDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SessionHostHealthCheckFailureDetails"/>. </summary>
        internal SessionHostHealthCheckFailureDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SessionHostHealthCheckFailureDetails"/>. </summary>
        /// <param name="message"> Failure message: hints on what is wrong and how to recover. </param>
        /// <param name="errorCode"> Error code corresponding for the failure. </param>
        /// <param name="lastHealthCheckOn"> The timestamp of the last update. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SessionHostHealthCheckFailureDetails(string message, int? errorCode, DateTimeOffset? lastHealthCheckOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Message = message;
            ErrorCode = errorCode;
            LastHealthCheckOn = lastHealthCheckOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Failure message: hints on what is wrong and how to recover. </summary>
        [WirePath("message")]
        public string Message { get; }
        /// <summary> Error code corresponding for the failure. </summary>
        [WirePath("errorCode")]
        public int? ErrorCode { get; }
        /// <summary> The timestamp of the last update. </summary>
        [WirePath("lastHealthCheckDateTime")]
        public DateTimeOffset? LastHealthCheckOn { get; }
    }
}
