// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DesktopVirtualization.Models
{
    /// <summary> The session host configuration for updating agent, monitoring agent, and stack component. </summary>
    public partial class SessionHostAgentUpdatePatchProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SessionHostAgentUpdatePatchProperties"/>. </summary>
        public SessionHostAgentUpdatePatchProperties()
        {
            MaintenanceWindows = new ChangeTrackingList<MaintenanceWindowPatchProperties>();
        }

        /// <summary> Initializes a new instance of <see cref="SessionHostAgentUpdatePatchProperties"/>. </summary>
        /// <param name="updateType"> The type of maintenance for session host components. </param>
        /// <param name="doesUseSessionHostLocalTime"> Whether to use localTime of the virtual machine. </param>
        /// <param name="maintenanceWindowTimeZone"> Time zone for maintenance as defined in https://docs.microsoft.com/en-us/dotnet/api/system.timezoneinfo.findsystemtimezonebyid?view=net-5.0. Must be set if useLocalTime is true. </param>
        /// <param name="maintenanceWindows"> List of maintenance windows. Maintenance windows are 2 hours long. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SessionHostAgentUpdatePatchProperties(SessionHostComponentUpdateType? updateType, bool? doesUseSessionHostLocalTime, string maintenanceWindowTimeZone, IList<MaintenanceWindowPatchProperties> maintenanceWindows, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            UpdateType = updateType;
            DoesUseSessionHostLocalTime = doesUseSessionHostLocalTime;
            MaintenanceWindowTimeZone = maintenanceWindowTimeZone;
            MaintenanceWindows = maintenanceWindows;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The type of maintenance for session host components. </summary>
        [WirePath("type")]
        public SessionHostComponentUpdateType? UpdateType { get; set; }
        /// <summary> Whether to use localTime of the virtual machine. </summary>
        [WirePath("useSessionHostLocalTime")]
        public bool? DoesUseSessionHostLocalTime { get; set; }
        /// <summary> Time zone for maintenance as defined in https://docs.microsoft.com/en-us/dotnet/api/system.timezoneinfo.findsystemtimezonebyid?view=net-5.0. Must be set if useLocalTime is true. </summary>
        [WirePath("maintenanceWindowTimeZone")]
        public string MaintenanceWindowTimeZone { get; set; }
        /// <summary> List of maintenance windows. Maintenance windows are 2 hours long. </summary>
        [WirePath("maintenanceWindows")]
        public IList<MaintenanceWindowPatchProperties> MaintenanceWindows { get; set; }
    }
}
