// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DesktopVirtualization.Models
{
    /// <summary> Action to be taken after a user disconnect during the ramp up period. </summary>
    public readonly partial struct SessionHandlingOperation : IEquatable<SessionHandlingOperation>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SessionHandlingOperation"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SessionHandlingOperation(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string DeallocateValue = "Deallocate";
        private const string HibernateValue = "Hibernate";

        /// <summary> None. </summary>
        public static SessionHandlingOperation None { get; } = new SessionHandlingOperation(NoneValue);
        /// <summary> Deallocate. </summary>
        public static SessionHandlingOperation Deallocate { get; } = new SessionHandlingOperation(DeallocateValue);
        /// <summary> Hibernate. </summary>
        public static SessionHandlingOperation Hibernate { get; } = new SessionHandlingOperation(HibernateValue);
        /// <summary> Determines if two <see cref="SessionHandlingOperation"/> values are the same. </summary>
        public static bool operator ==(SessionHandlingOperation left, SessionHandlingOperation right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SessionHandlingOperation"/> values are not the same. </summary>
        public static bool operator !=(SessionHandlingOperation left, SessionHandlingOperation right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SessionHandlingOperation"/>. </summary>
        public static implicit operator SessionHandlingOperation(string value) => new SessionHandlingOperation(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SessionHandlingOperation other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SessionHandlingOperation other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
