// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.DesktopVirtualization.Models
{
    /// <summary> Scaling plan reference to hostpool. </summary>
    public partial class ScalingHostPoolReference
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ScalingHostPoolReference"/>. </summary>
        public ScalingHostPoolReference()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ScalingHostPoolReference"/>. </summary>
        /// <param name="hostPoolId"> Arm path of referenced hostpool. </param>
        /// <param name="isScalingPlanEnabled"> Is the scaling plan enabled for this hostpool. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ScalingHostPoolReference(ResourceIdentifier hostPoolId, bool? isScalingPlanEnabled, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            HostPoolId = hostPoolId;
            IsScalingPlanEnabled = isScalingPlanEnabled;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Arm path of referenced hostpool. </summary>
        [WirePath("hostPoolArmPath")]
        public ResourceIdentifier HostPoolId { get; set; }
        /// <summary> Is the scaling plan enabled for this hostpool. </summary>
        [WirePath("scalingPlanEnabled")]
        public bool? IsScalingPlanEnabled { get; set; }
    }
}
